/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks;

import fr.minepiece.common.blocks.BlockRotatable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockLongHorizontal
extends BlockRotatable {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);

    public BlockLongHorizontal(Material material, MapColor mapColor, String blockName) {
        super(material, mapColor, blockName);
        this.func_180632_j(this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockLongHorizontal(Material materialIn, String blockName) {
        this(materialIn, MapColor.field_151660_b, blockName);
    }

    public BlockLongHorizontal(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, blockName);
        this.func_180632_j(this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        enumfacing = enumfacing.func_176746_e();
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                // empty if block
            }
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K && state.func_177229_b(PART) == EnumPartType.FOOT) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            BlockPos headPos = pos.func_177972_a(facing.func_176746_e());
            if (worldIn.func_175623_d(headPos)) {
                worldIn.func_180501_a(headPos, state.func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)), 3);
            } else {
                worldIn.func_175698_g(pos);
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (!super.func_176196_c(worldIn, pos)) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos headPos = pos.func_177972_a(facing);
            if (!worldIn.func_175623_d(pos) || !worldIn.func_175623_d(headPos)) continue;
            return true;
        }
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.FOOT && worldIn.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)FACING, (Comparable)enumfacing) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState adjacentState;
        if (state.func_177229_b(PART) == EnumPartType.FOOT && (adjacentState = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() == this) {
            state = state.func_177226_a(PART, adjacentState.func_177229_b(PART));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isHeadPiece(IBlockState state) {
        return state.func_177229_b(PART) == EnumPartType.HEAD;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

