/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks;

import fr.minepiece.MinePiece;
import fr.minepiece.common.init.ModTools;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarreauFer
extends BlockPane {
    private static Map<UUID, Map<BlockPos, Integer>> playersDisassembling = new HashMap<UUID, Map<BlockPos, Integer>>();
    public static final PropertyBool DISASSEMBLING = PropertyBool.func_177716_a((String)"disassembling");
    private static final int DISASSEMBLY_TIME = 200;

    public BlockBarreauFer() {
        super(Material.field_151573_f, true);
        this.func_149663_c("barreau_fer_block");
        this.setRegistryName("barreau_fer_block");
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(MinePiece.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176241_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176242_M, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176243_N, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176244_O, (Comparable)Boolean.FALSE).func_177226_a((IProperty)DISASSEMBLING, (Comparable)Boolean.FALSE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176241_b, field_176242_M, field_176244_O, field_176243_N, DISASSEMBLING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DISASSEMBLING, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DISASSEMBLING) != false ? 1 : 0;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        super.func_180649_a(worldIn, pos, playerIn);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)DISASSEMBLING)).booleanValue()) {
            boolean stillDisassembling = false;
            for (UUID playerId : playersDisassembling.keySet()) {
                Map<BlockPos, Integer> playerBlocks = playersDisassembling.get(playerId);
                if (!playerBlocks.containsKey(pos)) continue;
                stillDisassembling = true;
                break;
            }
            if (!stillDisassembling) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DISASSEMBLING, (Comparable)Boolean.valueOf(false)));
            } else {
                if (rand.nextInt(5) == 0) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187778_dq, SoundCategory.BLOCKS, 0.3f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f);
                }
                for (int i = 0; i < 2; ++i) {
                    float px = (float)pos.func_177958_n() + 0.5f + (rand.nextFloat() - 0.5f) * 0.5f;
                    float py = (float)pos.func_177956_o() + 0.5f + (rand.nextFloat() - 0.5f) * 0.5f;
                    float pz = (float)pos.func_177952_p() + 0.5f + (rand.nextFloat() - 0.5f) * 0.5f;
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0, new int[0]);
                }
                worldIn.func_175684_a(pos, (Block)this, 5 + rand.nextInt(5));
            }
        }
    }

    public static void onPlayerTick(EntityPlayer player) {
        UUID playerId = player.func_110124_au();
        if (playersDisassembling.containsKey(playerId)) {
            Map<BlockPos, Integer> playerBlocks = playersDisassembling.get(playerId);
            HashMap<BlockPos, Integer> updatedBlocks = new HashMap<BlockPos, Integer>();
            World world = player.field_70170_p;
            for (Map.Entry<BlockPos, Integer> entry : playerBlocks.entrySet()) {
                BlockPos pos = entry.getKey();
                int timeLeft = entry.getValue() - 1;
                if (player.func_174818_b(pos) > 10.0) {
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockBarreauFer)) continue;
                    IBlockState state = world.func_180495_p(pos);
                    world.func_175656_a(pos, state.func_177226_a((IProperty)DISASSEMBLING, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (timeLeft <= 0) {
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockBarreauFer)) continue;
                    world.func_184133_a(null, pos, SoundEvents.field_187769_eM, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
                    world.func_175698_g(pos);
                    ItemStack mainHandItem = player.func_184614_ca();
                    ItemStack offHandItem = player.func_184592_cb();
                    if (player.field_71075_bZ.field_75098_d) continue;
                    if (mainHandItem.func_77973_b() == ModTools.PINCE) {
                        mainHandItem.func_77972_a(1, (EntityLivingBase)player);
                        continue;
                    }
                    if (offHandItem.func_77973_b() != ModTools.PINCE) continue;
                    offHandItem.func_77972_a(1, (EntityLivingBase)player);
                    continue;
                }
                updatedBlocks.put(pos, timeLeft);
                if (timeLeft % 20 != 0 || !(world.func_180495_p(pos).func_177230_c() instanceof BlockBarreauFer)) continue;
                world.func_184133_a(null, pos, SoundEvents.field_187770_dm, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
            }
            if (updatedBlocks.isEmpty()) {
                playersDisassembling.remove(playerId);
            } else {
                playersDisassembling.put(playerId, updatedBlocks);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        UUID playerId = playerIn.func_110124_au();
        if (heldItem.func_77973_b() == ModTools.PINCE) {
            if (!worldIn.field_72995_K) {
                Map playerBlocks;
                boolean alreadyDisassembling = false;
                if (playersDisassembling.containsKey(playerId)) {
                    playerBlocks = playersDisassembling.get(playerId);
                    alreadyDisassembling = playerBlocks.containsKey(pos);
                }
                if (!alreadyDisassembling) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 0.8f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f);
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DISASSEMBLING, (Comparable)Boolean.valueOf(true)));
                    playerBlocks = playersDisassembling.getOrDefault(playerId, new HashMap());
                    playerBlocks.put(pos, 200);
                    playersDisassembling.put(playerId, playerBlocks);
                    worldIn.func_175684_a(pos, (Block)this, 5);
                }
            }
            return true;
        }
        return false;
    }
}

