/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.utils;

import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.minepiece.common.api.jobs.dto.LevelUpReward;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.init.ModConfiguration;
import fr.minepiece.common.utils.BerryUtils;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;

public class PlayerUtils {
    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static EntityPlayer getPlayerByUsername(String username) {
        try {
            return Minecraft.func_71410_x().field_71441_e.func_72924_a(username);
        }
        catch (Exception e) {
            e.printStackTrace();
            MinecraftServer server = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73046_m();
            if (server != null) {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(username);
                if (player != null) {
                    System.out.println("Found player: " + player.func_70005_c_());
                    return player;
                }
                System.err.println("Player not found with username: " + username);
            } else {
                System.err.println("MinecraftServer instance is null.");
            }
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static EntityPlayerMP getServerPlayerByUsername(String username) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            EntityPlayerMP player = server.func_184103_al().func_152612_a(username);
            if (player != null) {
                return player;
            }
            System.err.println("Player not found with username: " + username);
        } else {
            System.err.println("MinecraftServer instance is null.");
        }
        return null;
    }

    @SideOnly(value=Side.SERVER)
    public static void kickPlayer(String username, TextComponentString kickReason) {
        Objects.requireNonNull(PlayerUtils.getServerPlayerByUsername((String)username)).field_71135_a.func_194028_b((ITextComponent)kickReason);
    }

    public static boolean isPlayerOnline(EntityPlayerMP player) {
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        return playerList.func_181057_v().contains(player);
    }

    public static boolean isPlayerOnline(String username) {
        EntityPlayerMP player = (EntityPlayerMP)PlayerUtils.getPlayerByUsername(username);
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        return playerList.func_181057_v().contains(player);
    }

    public static void resetAttackSpeed(EntityPlayer player) {
        RangedAttribute attackSpeedAttribute = new RangedAttribute(null, "generic.attackSpeed", 4.0, 0.0, Double.MAX_VALUE);
        IAttributeInstance attackSpeedInstance = player.func_110148_a((IAttribute)attackSpeedAttribute);
        System.out.println("BEFORE RESET: " + attackSpeedInstance.func_111126_e());
        attackSpeedInstance.func_111128_a(attackSpeedAttribute.func_111110_b());
        System.out.println("AFTER RESET: " + attackSpeedInstance.func_111126_e());
    }

    public static void rescalePlayer(float scale, EntityPlayer player) {
        UUID uuidHeight = UUID.fromString("5440b01a-974f-4495-bb9a-c7c87424bca4");
        UUID uuidWidth = UUID.fromString("3949d2ed-b6cc-4330-9c13-98777f48ea51");
        UUID uuidReach1 = UUID.fromString("854e0004-c218-406c-a9e2-590f1846d80b");
        UUID uuidReach2 = UUID.fromString("216080dc-22d3-4eff-a730-190ec0210d5c");
        scale = MathHelper.func_76131_a((float)scale, (float)0.125f, (float)10.0f);
        HashMultimap attributes = HashMultimap.create();
        HashMultimap removeableAttributes = HashMultimap.create();
        HashMultimap removeableAttributes2 = HashMultimap.create();
        attributes.put((Object)ArtemisLibAttributes.ENTITY_HEIGHT.func_111108_a(), (Object)new AttributeModifier(uuidHeight, "Player Height", (double)(scale - 1.0f), 2));
        attributes.put((Object)ArtemisLibAttributes.ENTITY_WIDTH.func_111108_a(), (Object)new AttributeModifier(uuidWidth, "Player Width", MathHelper.func_151237_a((double)(scale - 1.0f), (double)-0.6, (double)0.8f), 2));
        removeableAttributes.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach1, "Player Reach 1", (double)(scale - 1.0f), 2));
        removeableAttributes2.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach2, "Player Reach 2", -MathHelper.func_151237_a((double)(scale - 1.0f), (double)0.33, (double)Double.MAX_VALUE), 2));
        if (scale > 1.0f) {
            player.func_110140_aT().func_111147_b((Multimap)removeableAttributes);
        } else {
            player.func_110140_aT().func_111148_a((Multimap)removeableAttributes);
        }
        if (scale < 1.0f) {
            player.func_110140_aT().func_111147_b((Multimap)removeableAttributes2);
        } else {
            player.func_110140_aT().func_111148_a((Multimap)removeableAttributes2);
        }
        player.func_110140_aT().func_111147_b((Multimap)attributes);
        player.func_70606_j(player.func_110138_aP());
    }

    public static void changeVelocity(Vec3d vec3d, EntityPlayer player) {
        player.field_70159_w = vec3d.field_72450_a;
        player.field_70181_x = vec3d.field_72448_b;
        player.field_70179_y = vec3d.field_72449_c;
        player.field_70133_I = true;
        player.func_145747_a((ITextComponent)new TextComponentString("x: " + vec3d.field_72450_a));
        player.func_145747_a((ITextComponent)new TextComponentString("y: " + vec3d.field_72448_b));
        player.func_145747_a((ITextComponent)new TextComponentString("z: " + vec3d.field_72449_c));
    }

    public static void changeVelocity(float pitch, float yaw, EntityPlayer player) {
        Vec3d vec3d = Vec3d.func_189986_a((float)pitch, (float)yaw);
        player.field_70159_w = vec3d.field_72450_a;
        player.field_70181_x = vec3d.field_72448_b;
        player.field_70179_y = vec3d.field_72449_c;
        player.field_70133_I = true;
    }

    public static void changeVelocity(double x, double y, double z, EntityPlayer player) {
        player.field_70159_w = x;
        player.field_70181_x = y;
        player.field_70179_y = z;
        player.field_70133_I = true;
    }

    public static void addXpToPlayer(EntityPlayerMP playerMP, int xpToAdd) {
        IMinePieceData cap = (IMinePieceData)playerMP.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        assert (cap != null);
        if (cap.getLevel() >= ModConfiguration.maxPlayerLevel && ModConfiguration.maxPlayerLevel != -1) {
            return;
        }
        cap.addXP(xpToAdd);
        while (PlayerUtils.canLevelUp(cap.getLevel(), cap.getXP())) {
            PlayerUtils.levelUpPlayer(playerMP);
        }
        cap.clientSync(playerMP);
    }

    public static void levelUpPlayer(EntityPlayerMP player) {
        IMinePieceData cap = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        assert (cap != null);
        int lastLevel = cap.getLevel() + 1;
        int lastRequiredXP = (int)PlayerUtils.calculateRequiredXP(lastLevel);
        cap.setLevel(lastLevel);
        cap.setXP(cap.getXP() - lastRequiredXP);
        IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        stats.setStatPoints(stats.getStatPoints() + 1);
        stats.clientSync(player);
        cap.getRace().getInstance().levelUp((EntityPlayer)player, cap.getLevel());
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aVous venez d'atteindre le niveau \u00a7c" + cap.getLevel()));
    }

    public static boolean canLevelUp(int currentLevel, int currentXP) {
        long requiredXP = PlayerUtils.calculateRequiredXP(currentLevel + 1);
        return (long)currentXP >= requiredXP;
    }

    public static long calculateRequiredXP(int targetLevel) {
        long totalXP = 0L;
        long baseXP = 200L;
        for (int i = 0; i < targetLevel; ++i) {
            float multiplier = PlayerUtils.getXpMultiplier(i + 1);
            totalXP += baseXP;
            baseXP = (long)((float)baseXP * multiplier);
        }
        return totalXP;
    }

    private static float getXpMultiplier(int level) {
        if (level < 8) {
            return 1.1f;
        }
        if (level >= 8 && level < 16) {
            return 1.2f;
        }
        if (level >= 16 && level < 38) {
            return 1.1f;
        }
        if (level >= 38 && level < 60) {
            return 1.05f;
        }
        return 1.03f;
    }

    public static void addJobXpToPlayer(EntityPlayerMP playerMP, int xpToAdd) {
        if (playerMP.field_70170_p.field_72995_K) {
            return;
        }
        IMinePieceData cap = (IMinePieceData)playerMP.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (cap == null) {
            LogManager.getLogger((String)"MinePiece Jobs").error("Impossible d'obtenir les capacit\u00e9s du joueur");
            return;
        }
        if (cap.getJobLevel() >= ModConfiguration.maxJobLevel && ModConfiguration.maxJobLevel != -1) {
            return;
        }
        cap.addJobXP(xpToAdd);
        LogManager.getLogger((String)"MinePiece Jobs").info("Ajout de {} XP de job au joueur {}", (Object)xpToAdd, (Object)playerMP.func_70005_c_());
        while (PlayerUtils.canJobLevelUp(cap.getJobLevel(), cap.getJobXP())) {
            int newLevel = cap.getJobLevel() + 1;
            int requiredXP = (int)PlayerUtils.calculateRequiredXP(newLevel);
            cap.setJobLevel(newLevel);
            cap.setJobXP(cap.getJobXP() - requiredXP);
            if (cap.getJob() != null) {
                PlayerUtils.levelUpJobs(playerMP, cap, newLevel);
            }
            playerMP.func_145747_a((ITextComponent)new TextComponentString("\u00a7aVous venez d'atteindre le niveau \u00a7c" + newLevel + "\u00a7a de \u00a7c" + cap.getJob().getName()));
        }
        cap.clientSync(playerMP);
    }

    public static boolean canJobLevelUp(int currentLevel, int currentXP) {
        long requiredXP = PlayerUtils.calculateRequiredXP(currentLevel + 1);
        return (long)currentXP >= requiredXP;
    }

    private static void levelUpJobs(EntityPlayerMP playerMP, IMinePieceData cap, int newLevel) {
        LevelUpReward reward = LevelUpReward.getRewardForJob(cap.getJob(), newLevel);
        if (reward != null && reward.berries > 0) {
            BerryUtils.giveBerries((EntityPlayer)playerMP, newLevel);
        }
    }
}

