/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.stats;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.stats.MinePieceAttributeModifier;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.init.ModConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;

public class StatsUtils {
    private static final ArrayList<MinePieceAttributeModifier> giantModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.GIANT_SPEED, MinePieceAttributeModifier.GIANT_MINING, MinePieceAttributeModifier.GIANT_HEIGHT, MinePieceAttributeModifier.GIANT_WIDTH, MinePieceAttributeModifier.GIANT_REACH));
    private static final ArrayList<MinePieceAttributeModifier> humanModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.HUMAN_HEALTH));
    private static final ArrayList<MinePieceAttributeModifier> humanUpgradedModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.HUMAN_HEALTH_UP));
    private static final ArrayList<MinePieceAttributeModifier> tontattaModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.TONTATTA_STRENGHT, MinePieceAttributeModifier.TONTATTA_WIDTH, MinePieceAttributeModifier.TONTATTA_HEIGHT));
    private static final ArrayList<MinePieceAttributeModifier> tontattaUpgradedModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.TONTATTA_HEALTH));
    private static final ArrayList<MinePieceAttributeModifier> minksModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.MINKS_SPEED, MinePieceAttributeModifier.MINKS_STRENGTH));
    private static final ArrayList<MinePieceAttributeModifier> minksUpgradedModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.MINKS_SPEED_UP, MinePieceAttributeModifier.MINKS_STRENGTH_UP));
    private static final ArrayList<MinePieceAttributeModifier> fishmanInWaterModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.FISHMAN_SPEED_IN_WATER, MinePieceAttributeModifier.FISHMAN_STRENGTH_IN_WATER));
    private static final ArrayList<MinePieceAttributeModifier> fishmanOutWaterModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.FISHMAN_SPEED_OUT_WATER, MinePieceAttributeModifier.FISHMAN_STRENGTH_OUT_WATER));
    private static final ArrayList<MinePieceAttributeModifier> fishmanInWaterUpgradedModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.FISHMAN_UP_SPEED_IN_WATER, MinePieceAttributeModifier.FISHMAN_UP_STRENGTH_IN_WATER));
    private static final ArrayList<MinePieceAttributeModifier> fishmanOutWaterUpgradedModifiers = new ArrayList<MinePieceAttributeModifier>(Arrays.asList(MinePieceAttributeModifier.FISHMAN_UP_SPEED_OUT_WATER, MinePieceAttributeModifier.FISHMAN_UP_STRENGTH_OUT_WATER));
    private static final UUID STATS_HEALTH_ID = UUID.fromString("c8edb9dc-2cb4-11ee-be56-0242ac120002");
    private static final UUID STATS_SPEED_ID = UUID.fromString("75cd2f30-2cbe-11ee-be56-0242ac120002");
    private static final UUID STATS_STRENGHT_ID = UUID.fromString("ea5682cc-2cc1-11ee-be56-0242ac120002");

    public static void applyRaceModifiers(EntityPlayer player, MinePieceRaces race) {
        switch (race) {
            case GIANT: {
                StatsUtils.applyModifiers(player, giantModifiers);
                break;
            }
            case HUMAN: {
                StatsUtils.applyModifiers(player, humanModifiers);
                break;
            }
            case MINKS: {
                StatsUtils.applyModifiers(player, minksModifiers);
                break;
            }
            case CYBORG: {
                break;
            }
            case FISHMAN: {
                player.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111128_a((double)ModConfiguration.fishman_speed_boost_passive);
                break;
            }
            case TONTATTA: {
                StatsUtils.applyModifiers(player, tontattaModifiers);
            }
        }
    }

    public static void applyUpgradedRaceModifiers(EntityPlayer player, MinePieceRaces race) {
        switch (race) {
            case GIANT: {
                break;
            }
            case HUMAN: {
                StatsUtils.applyModifiers(player, humanUpgradedModifiers);
                break;
            }
            case MINKS: {
                StatsUtils.applyModifiers(player, minksUpgradedModifiers);
                break;
            }
            case CYBORG: {
                break;
            }
            case FISHMAN: {
                player.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111128_a((double)ModConfiguration.fishman_speed_boost_passive);
                break;
            }
            case TONTATTA: {
                StatsUtils.applyModifiers(player, tontattaUpgradedModifiers);
            }
        }
    }

    public static void removeRaceModifiers(EntityPlayer player, MinePieceRaces race) {
        switch (race) {
            case GIANT: {
                StatsUtils.removeModifiers(player, giantModifiers);
                break;
            }
            case HUMAN: {
                StatsUtils.removeModifiers(player, humanModifiers);
                break;
            }
            case MINKS: {
                StatsUtils.removeModifiers(player, minksModifiers);
                break;
            }
            case CYBORG: {
                break;
            }
            case FISHMAN: {
                break;
            }
            case TONTATTA: {
                StatsUtils.removeModifiers(player, tontattaModifiers);
            }
        }
    }

    public static void removeUpgradedRaceModifiers(EntityPlayer player, MinePieceRaces race) {
        switch (race) {
            case GIANT: {
                break;
            }
            case HUMAN: {
                break;
            }
            case MINKS: {
                StatsUtils.removeModifiers(player, minksUpgradedModifiers);
                break;
            }
            case CYBORG: {
                break;
            }
            case FISHMAN: {
                break;
            }
            case TONTATTA: {
                StatsUtils.removeModifiers(player, tontattaUpgradedModifiers);
            }
        }
    }

    public static void applyFishmanModifiers(EntityPlayer player, boolean upgraded) {
        if (upgraded) {
            if (player.func_70090_H()) {
                StatsUtils.removeModifiers(player, fishmanOutWaterUpgradedModifiers);
                StatsUtils.removeModifiers(player, fishmanInWaterModifiers);
                StatsUtils.removeModifiers(player, fishmanOutWaterModifiers);
                StatsUtils.applyModifiers(player, fishmanInWaterUpgradedModifiers);
            } else {
                StatsUtils.removeModifiers(player, fishmanInWaterUpgradedModifiers);
                StatsUtils.removeModifiers(player, fishmanInWaterModifiers);
                StatsUtils.removeModifiers(player, fishmanOutWaterModifiers);
                StatsUtils.applyModifiers(player, fishmanOutWaterUpgradedModifiers);
            }
        } else if (player.func_70090_H()) {
            StatsUtils.removeModifiers(player, fishmanInWaterUpgradedModifiers);
            StatsUtils.removeModifiers(player, fishmanOutWaterUpgradedModifiers);
            StatsUtils.removeModifiers(player, fishmanOutWaterModifiers);
            StatsUtils.applyModifiers(player, fishmanInWaterModifiers);
        } else {
            StatsUtils.removeModifiers(player, fishmanInWaterUpgradedModifiers);
            StatsUtils.removeModifiers(player, fishmanOutWaterUpgradedModifiers);
            StatsUtils.removeModifiers(player, fishmanInWaterModifiers);
            StatsUtils.applyModifiers(player, fishmanOutWaterModifiers);
        }
    }

    private static void applyModifiers(EntityPlayer player, ArrayList<MinePieceAttributeModifier> modifiers) {
        for (MinePieceAttributeModifier modifier : modifiers) {
            IAttributeInstance iattributeinstance = player.func_110148_a(modifier.getiAttribute());
            StatsUtils.removeModifier(player, modifier);
            iattributeinstance.func_111121_a(modifier.getAttributeModifier());
        }
    }

    private static void removeModifiers(EntityPlayer player, ArrayList<MinePieceAttributeModifier> modifiers) {
        modifiers.forEach(modifier -> StatsUtils.removeModifier(player, modifier));
    }

    public static void resetModifiers(EntityPlayer player) {
        StatsUtils.resetModifier(player, SharedMonsterAttributes.field_188790_f);
        StatsUtils.resetModifier(player, SharedMonsterAttributes.field_111264_e);
        StatsUtils.resetModifier(player, SharedMonsterAttributes.field_111263_d);
        StatsUtils.resetModifier(player, SharedMonsterAttributes.field_111267_a);
        StatsUtils.resetModifier(player, EntityLivingBase.SWIM_SPEED);
        StatsUtils.removeModifiers(player, giantModifiers);
        StatsUtils.removeModifiers(player, humanModifiers);
        StatsUtils.removeModifiers(player, humanUpgradedModifiers);
        StatsUtils.removeModifiers(player, tontattaModifiers);
        StatsUtils.removeModifiers(player, tontattaUpgradedModifiers);
        StatsUtils.removeModifiers(player, minksModifiers);
        StatsUtils.removeModifiers(player, minksUpgradedModifiers);
        StatsUtils.removeModifiers(player, fishmanInWaterModifiers);
        StatsUtils.removeModifiers(player, fishmanOutWaterModifiers);
        StatsUtils.removeModifiers(player, fishmanInWaterUpgradedModifiers);
        StatsUtils.removeModifiers(player, fishmanOutWaterUpgradedModifiers);
        player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    private static void resetModifier(EntityPlayer player, IAttribute attribute) {
        IAttributeInstance iattributeinstance = player.func_110148_a(attribute);
        iattributeinstance.func_111128_a(attribute.func_111110_b());
    }

    private static void removeModifier(EntityPlayer player, MinePieceAttributeModifier modifier) {
        IAttributeInstance attributeInstance = player.func_110148_a(modifier.getiAttribute());
        attributeInstance.func_111128_a(modifier.getiAttribute().func_111110_b());
        if (attributeInstance.func_111127_a(modifier.getUuid()) != null) {
            attributeInstance.func_188479_b(modifier.getUuid());
        }
    }

    public static void updateStats(EntityPlayer player) {
        IMinePieceStats data = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        StatsUtils.reloadHealthStat(player, data);
        StatsUtils.reloadSpeedStat(player, data);
        StatsUtils.reloadStrenghtStat(player, data);
    }

    private static void reloadHealthStat(EntityPlayer player, IMinePieceStats stats) {
        System.out.println("Reloading health stat!");
        int health = stats.getHP();
        AttributeModifier STATS_HEALTH_MODIFIER = new AttributeModifier(STATS_HEALTH_ID, "Stats health modifier", (double)health, 0).func_111168_a(false);
        IAttributeInstance healthInstance = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (healthInstance.func_111127_a(STATS_HEALTH_ID) != null) {
            healthInstance.func_188479_b(STATS_HEALTH_ID);
        }
        healthInstance.func_111121_a(STATS_HEALTH_MODIFIER);
    }

    private static void reloadSpeedStat(EntityPlayer player, IMinePieceStats stats) {
        System.out.println("Reloading speed stat!");
        int speed = stats.getSpeed();
        AttributeModifier STATS_SPEED_MODIFIER = new AttributeModifier(STATS_SPEED_ID, "Stats speed modifier", (double)speed * 0.00125, 0).func_111168_a(false);
        IAttributeInstance speedInstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speedInstance.func_111127_a(STATS_SPEED_ID) != null) {
            speedInstance.func_188479_b(STATS_SPEED_ID);
        }
        speedInstance.func_111121_a(STATS_SPEED_MODIFIER);
    }

    private static void reloadStrenghtStat(EntityPlayer player, IMinePieceStats stats) {
        System.out.println("Reloading strenght stat!");
        int strenght = stats.getStrength();
        AttributeModifier STATS_STRENGHT_MODIFIER = new AttributeModifier(STATS_STRENGHT_ID, "Stats strenght modifier", (double)((float)strenght * 0.1f), 0).func_111168_a(false);
        IAttributeInstance strenghtInstance = player.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (strenghtInstance.func_111127_a(STATS_STRENGHT_ID) != null) {
            strenghtInstance.func_188479_b(STATS_STRENGHT_ID);
        }
        strenghtInstance.func_111121_a(STATS_STRENGHT_MODIFIER);
    }
}

