/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.races;

import fr.minepiece.common.api.abilities.AbilitiesEnum;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaFriendBoostAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaHealthAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaJumpAbility;
import fr.minepiece.common.api.races.IMinePieceRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.stats.StatsUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class TontattaRace
implements IMinePieceRace {
    public static AbstractRaceAbility<TontattaRace> firstSkill = TontattaJumpAbility.INSTANCE;
    public static AbstractRaceAbility<TontattaRace> secondSkill = TontattaHealthAbility.INSTANCE;
    public static AbstractRaceAbility<TontattaRace> thirdSkill = TontattaFriendBoostAbility.INSTANCE;

    @Override
    public void init(EntityPlayer player, World world) {
        StatsUtils.resetModifiers(player);
        StatsUtils.updateStats(player);
        StatsUtils.applyRaceModifiers(player, MinePieceRaces.TONTATTA);
        if (((IMinePieceData)Objects.requireNonNull(player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null))).getLevel() >= 20) {
            StatsUtils.applyUpgradedRaceModifiers(player, MinePieceRaces.TONTATTA);
        }
    }

    @Override
    public void passive(EntityPlayer player, World world) {
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"jump_boost"), 160, 2, false, false));
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"speed"), 160, 0, false, false));
    }

    @Override
    public void powerUp(EntityPlayer player, World world) {
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"jump_boost"), 160, 2, false, false));
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"speed"), 160, 1, false, false));
    }

    @Override
    public HashMap<Integer, AbilitiesEnum> getAbilities() {
        return new HashMap<Integer, AbilitiesEnum>(){
            {
                this.put(5, AbilitiesEnum.TONTATTA_JUMP);
                this.put(15, AbilitiesEnum.TONTATTA_HEAL);
                this.put(30, AbilitiesEnum.TONTATTA_FRIEND_BOOST);
            }
        };
    }
}

