/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.races;

import fr.minepiece.common.api.abilities.AbilitiesEnum;
import fr.minepiece.common.api.races.IMinePieceRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.stats.StatsUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class HumanRace
implements IMinePieceRace {
    @Override
    public void init(EntityPlayer player, World world) {
        StatsUtils.resetModifiers(player);
        StatsUtils.updateStats(player);
        StatsUtils.applyRaceModifiers(player, MinePieceRaces.HUMAN);
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        assert (data != null);
        if (data.getLevel() < 20) {
            StatsUtils.applyRaceModifiers(player, MinePieceRaces.HUMAN);
        } else if (data.getLevel() >= 20) {
            StatsUtils.applyUpgradedRaceModifiers(player, MinePieceRaces.HUMAN);
        }
    }

    @Override
    public void passive(EntityPlayer player, World world) {
        boolean shouldHeal = false;
        if (player.func_110143_aJ() == player.func_110138_aP()) {
            shouldHeal = true;
        }
        if (shouldHeal) {
            player.func_70691_i(player.func_110138_aP());
        }
    }

    @Override
    public void powerUp(EntityPlayer player, World world) {
        boolean shouldHeal = false;
        if (player.func_110143_aJ() == player.func_110138_aP()) {
            shouldHeal = true;
        }
        if (shouldHeal) {
            player.func_70691_i(player.func_110138_aP());
        }
    }

    @Override
    public HashMap<Integer, AbilitiesEnum> getAbilities() {
        return new HashMap<Integer, AbilitiesEnum>(){
            {
                this.put(5, AbilitiesEnum.HUMAN_SKY_WALK);
                this.put(15, AbilitiesEnum.HUMAN_METALIUM);
                this.put(30, AbilitiesEnum.HUMAN_PIED_OURAGAN);
            }
        };
    }
}

