/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.jobs;

import fr.minepiece.common.api.abilities.AbilitiesEnum;
import fr.minepiece.common.api.jobs.dto.LevelUpReward;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public interface IMinePieceJob {
    public void levelUp(EntityPlayer var1, int var2);

    public HashMap<Integer, LevelUpReward> getRewards();

    public HashMap<Integer, AbilitiesEnum> getAbilities();

    public void init(EntityPlayer var1, World var2);

    default public long getNeededXP(int targetLevel) {
        double growthFactor = this.generateGrowthFactor(targetLevel);
        return this.generateValue(targetLevel, growthFactor);
    }

    default public void jobLevelUp(EntityPlayer player, int newLevel) {
        this.init(player, player.field_70170_p);
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
    }

    default public double generateGrowthFactor(int n) {
        double initialGrowthFactor = 1.25;
        return initialGrowthFactor + 0.10409 * ((double)(n - 1) / 5.0);
    }

    default public long generateValue(int n, double growthFactor) {
        long value = 500L;
        for (int i = 1; i < n; ++i) {
            value = (long)((double)value * growthFactor);
        }
        return value;
    }
}

