/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.tontatta;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.TontattaRace;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.TontattaJumpPacket;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TontattaJumpAbility
extends AbstractRaceAbility<TontattaRace> {
    public static final TontattaJumpAbility INSTANCE = new TontattaJumpAbility();
    public static final ArrayList<Integer> hasActivatedJumpAbility = new ArrayList();

    private TontattaJumpAbility() {
        super(true, 35, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/tontatta_jump.png"), "tontatta:jump");
        this.setCooldownInMilliseconds(5000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        player.field_70181_x = 1.3;
        player.field_70133_I = true;
        ModPackets.NETWORK.sendTo((IMessage)new TontattaJumpPacket(player.func_145782_y()), player);
        hasActivatedJumpAbility.add(player.func_145782_y());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            if (!hasActivatedJumpAbility.contains(player.func_145782_y())) {
                return;
            }
            if (player.field_70181_x < 0.0) {
                player.field_70181_x *= 0.5;
                this.applyMotionInDirection(player);
                player.field_70133_I = true;
            }
        }
    }

    private void applyMotionInDirection(EntityPlayer player) {
        double zMotion = Math.cos(player.field_70177_z * ((float)Math.PI / 180));
        double xMotion = Math.sin(player.field_70177_z * ((float)Math.PI / 180));
        double blocEnAvant = 0.03;
        player.func_70024_g(-xMotion * blocEnAvant, 0.0, zMotion * blocEnAvant);
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (hasActivatedJumpAbility.contains(player.func_145782_y())) {
            hasActivatedJumpAbility.removeIf(integer -> integer.intValue() == player.func_145782_y());
            event.setCanceled(true);
        }
    }
}

