/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.tontatta;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.TontattaRace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TontattaFriendBoostAbility
extends AbstractRaceAbility<TontattaRace> {
    public static final TontattaFriendBoostAbility INSTANCE = new TontattaFriendBoostAbility();
    public static HashMap<EntityPlayer, EntityPlayer> selectedFriends = new HashMap();
    private static final HashMap<Integer, Long> selectionTimePerPlayer = new HashMap();

    private TontattaFriendBoostAbility() {
        super(true, 110, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/tontatta_plus_fort.png"), "tontatta:friend_boost");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        this.setPlayerInFriendSelection(player);
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Vous avez 15 secondes pour taper un co-\u00e9quipier \u00e0 boost"));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<Map.Entry<Integer, Long>> iterator = selectionTimePerPlayer.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Long> entry = iterator.next();
                int entityId = entry.getKey();
                long endTime = entry.getValue();
                EntityPlayer player = selectedFriends.keySet().stream().filter(selectedFriend -> selectedFriend.func_145782_y() == entityId).findFirst().orElse(null);
                if (endTime > System.currentTimeMillis() && selectedFriends.get(player) == null || endTime >= System.currentTimeMillis() && selectedFriends.get(player) == null) continue;
                iterator.remove();
                if (selectedFriends.get(player) != null) continue;
                assert (player != null);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Votre temps de s\u00e9lection s'est \u00e9coul\u00e9!"));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityPlayer && selectedFriends.get(event.getEntityPlayer()) == null && selectionTimePerPlayer.getOrDefault(event.getEntityPlayer().func_145782_y(), 0L) > System.currentTimeMillis()) {
            EntityPlayer selectedFriend = (EntityPlayer)event.getTarget();
            this.applyFriendEffects(selectedFriend);
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Vous avez boost " + TextFormatting.DARK_GREEN + selectedFriend.func_70005_c_() + TextFormatting.GREEN + " !"));
            selectedFriend.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + event.getEntityPlayer().func_70005_c_() + TextFormatting.GREEN + " vous a boost!"));
            event.getTarget().field_70170_p.func_184148_a(null, selectedFriend.field_70165_t, selectedFriend.field_70163_u, selectedFriend.field_70161_v, SoundEvents.field_187634_bp, SoundCategory.PLAYERS, 1.0f, 1.5f);
            event.setCanceled(true);
        }
    }

    private void applyFriendEffects(EntityPlayer player) {
        PotionEffect speedEffect = new PotionEffect(Potion.func_180142_b((String)"minecraft:speed"), 600, 0);
        PotionEffect strengthEffect = new PotionEffect(Potion.func_180142_b((String)"minecraft:strength"), 600, 0);
        player.func_70690_d(speedEffect);
        player.func_70690_d(strengthEffect);
    }

    private void setPlayerInFriendSelection(EntityPlayerMP player) {
        selectionTimePerPlayer.put(player.func_145782_y(), System.currentTimeMillis() + 15000L);
        selectedFriends.put((EntityPlayer)player, null);
    }
}

