/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.minks;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.MinksRace;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.ParticleBlurPacket;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MinksSulongAbility
extends AbstractRaceAbility<MinksRace> {
    public static final MinksSulongAbility INSTANCE = new MinksSulongAbility();
    public static ArrayList<EntityPlayer> playersInSulong = new ArrayList();

    private MinksSulongAbility() {
        super(true, 120, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/minks_sulong.png"), "minks:sulong");
        this.setCooldownInMilliseconds(600000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        playersInSulong.add((EntityPlayer)player);
        player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100000, 9, false, false));
    }

    @SubscribeEvent
    public void onPlayerTick(final TickEvent.PlayerTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && playersInSulong.contains(event.player)) {
            if (event.player.field_70170_p.func_72935_r()) {
                this.disableSulong(new ArrayList<EntityPlayer>(){
                    {
                        this.add(event.player);
                    }
                });
            } else {
                event.player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 0, false, false));
                event.player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 400, 3, false, false));
                ModPackets.NETWORK.sendToAll((IMessage)new ParticleBlurPacket(event.player.field_70170_p.func_72912_H().func_76065_j(), new Vec3d(event.player.field_70165_t + MinksSulongAbility.generateRandomNumber(-1.0, 1.0), event.player.field_70163_u + 1.0 + MinksSulongAbility.generateRandomNumber(-0.5, 0.5), event.player.field_70161_v + MinksSulongAbility.generateRandomNumber(-1.0, 1.0)), 8, 0xFFFFFF, true, 3.2f));
            }
        }
    }

    public static double generateRandomNumber(double minValue, double maxValue) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("minValue must be less than maxValue");
        }
        Random random = new Random();
        return minValue + (maxValue - minValue) * random.nextDouble();
    }

    public void disableSulong(ArrayList<EntityPlayer> players) {
        for (EntityPlayer player : players) {
            player.func_184589_d(MobEffects.field_76444_x);
            playersInSulong.remove(player);
        }
    }

    @Override
    protected boolean canExecute(EntityPlayerMP player) {
        if (this.isFullMoon(player)) {
            return super.canExecute(player);
        }
        return false;
    }

    private boolean isFullMoon(EntityPlayerMP playerMP) {
        System.out.println("MOON PHASE: " + playerMP.field_70170_p.field_73011_w.func_76559_b(playerMP.field_70170_p.func_72820_D()));
        return playerMP.field_70170_p.field_73011_w.func_76559_b(playerMP.field_70170_p.func_72820_D()) == 0 && !playerMP.field_70170_p.func_72935_r();
    }
}

