/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.minks;

import fr.minepiece.client.particles.minks.ElectricCircleParticle;
import fr.minepiece.client.particles.minks.ElectricCrossParticle;
import fr.minepiece.client.particles.minks.ElectricLineParticle;
import fr.minepiece.client.particles.vfx.implementations.ParticleCCBlur;
import fr.minepiece.client.render.sphere.SphereCallback;
import fr.minepiece.client.render.sphere.SphereManager;
import fr.minepiece.client.render.sphere.SphereRenderObject;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.MinksRace;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.MinksEWavePacket;
import fr.minepiece.common.utils.helpers.AABBHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MinksExplosionAbility
extends AbstractRaceAbility<MinksRace> {
    public static final MinksExplosionAbility INSTANCE = new MinksExplosionAbility();
    private static HashMap<String, Set<Integer>> damagedEntities = new HashMap();
    private static final Random RANDOM = new Random();
    private static final Random RANDOM_DOUBLE = new Random();

    private MinksExplosionAbility() {
        super(false, 40, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/minks_electro.png"), "minks:explosion");
        this.setCooldownInMilliseconds(10000);
    }

    @Override
    protected void execute(final EntityPlayerMP player) {
        damagedEntities.put(player.func_70005_c_(), new HashSet());
        MinksEWavePacket packet = new MinksEWavePacket(player.func_70005_c_(), new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        ModPackets.NETWORK.sendToAll((IMessage)packet);
        SphereRenderObject object = new SphereRenderObject(0.0f, new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v), new float[]{0.5059f, 0.796f, 0.8392f, 0.65f}, new SphereCallback(){

            @Override
            public void callback(SphereRenderObject object, Side side) {
                float length = object.getRadius();
                if (!(length >= 5.0f)) {
                    length = length <= 1.0f ? (length += 0.05f) : (length += 0.55f);
                }
                object.setRadius(length);
                if (side.isClient()) {
                    MinksExplosionAbility.doWaveParticles(object, length, 2);
                }
                if (side.isServer()) {
                    MinksExplosionAbility.dealDamage(object, player.func_70005_c_());
                }
            }
        }, 80);
        SphereManager.addSphere(object);
    }

    private static void dealDamage(SphereRenderObject object, String username) {
        EntityPlayerMP sendingPlayer = PlayerUtils.getServerPlayerByUsername(username);
        assert (sendingPlayer != null);
        int playerID = sendingPlayer.func_145782_y();
        World world = sendingPlayer.field_70170_p;
        List<AxisAlignedBB> boundingBoxes = AABBHelper.generateSphereBoundingBoxes(object.getCenter(), (double)object.getRadius(), 15);
        Iterator iterator = world.field_72996_f.iterator();
        Set affectedEntitiesId = damagedEntities.getOrDefault(username, new HashSet());
        HashSet<EntityLivingBase> affectedEntities = new HashSet<EntityLivingBase>();
        while (iterator.hasNext()) {
            EntityLivingBase entityLivingBase;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof EntityLivingBase) || affectedEntitiesId.contains(entity.func_145782_y()) || entity.func_145782_y() == playerID || !AABBHelper.doesEntityIntersectWithBoundingBoxes((Entity)(entityLivingBase = (EntityLivingBase)entity), boundingBoxes)) continue;
            affectedEntities.add(entityLivingBase);
            affectedEntitiesId.add(entityLivingBase.func_145782_y());
        }
        damagedEntities.put(username, affectedEntitiesId);
        for (EntityLivingBase entityLivingBase : affectedEntities) {
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)sendingPlayer), 6.0f);
            entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 6));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doWaveParticles(SphereRenderObject object, double radius, int particleCount) {
        Vec3d center = object.getCenter();
        particleCount = radius < 1.0 ? 1 : particleCount;
        Particle[] particles = new Particle[]{new ElectricLineParticle((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0), new ElectricCrossParticle((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0), new ElectricCircleParticle((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0)};
        for (int i = 0; i < particleCount; ++i) {
            double theta = RANDOM_DOUBLE.nextDouble() * 2.0 * Math.PI;
            double phi = RANDOM_DOUBLE.nextDouble() * Math.PI;
            double x = center.field_72450_a + radius * Math.sin(phi) * Math.cos(theta);
            double y = center.field_72448_b + radius * Math.sin(phi) * Math.sin(theta);
            double z = center.field_72449_c + radius * Math.cos(phi);
            Particle particleType = particles[RANDOM.nextInt(particles.length)];
            particleType.func_187109_b(x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particleType);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleCCBlur((World)Minecraft.func_71410_x().field_71441_e, x, y, z).setLife(20).setScale(3.0f).setColor(8506326).setGravity(0.0f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addWaveToRender(final MinksEWavePacket waveToRender) {
        SphereRenderObject object = new SphereRenderObject(0.0f, waveToRender.getCenter(), new float[]{0.5059f, 0.796f, 0.8392f, 0.65f}, new SphereCallback(){

            @Override
            public void callback(SphereRenderObject object, Side side) {
                float length = object.getRadius();
                if (!(length >= 5.0f)) {
                    length = length <= 1.0f ? (length += 0.05f) : (length += 0.55f);
                }
                object.setRadius(length);
                if (side.isClient()) {
                    MinksExplosionAbility.doWaveParticles(object, length, 2);
                }
                if (side.isServer()) {
                    MinksExplosionAbility.dealDamage(object, waveToRender.getUsername());
                }
            }
        }, 80);
        SphereManager.addFullSphere(object);
    }
}

