/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.minks;

import fr.minepiece.client.particles.ModParticles;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.races.MinksRace;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.SpawnParticlePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MinksDashAbility
extends AbstractRaceAbility<MinksRace> {
    public static final MinksDashAbility INSTANCE = new MinksDashAbility();
    private static HashMap<Integer, BlockPos> hasStartedDashAbility = new HashMap();
    private static ArrayList<Integer> hasActivatedDashAbility = new ArrayList();
    private static final Random RANDOM = new Random();

    private MinksDashAbility() {
        super(true, 75, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/minks_coup_de_poing.png"), "minks:dash");
        this.setCooldownInMilliseconds(10000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        BlockPos startPosition = player.func_180425_c();
        Vec3d lookVec = player.func_70040_Z();
        double strength = 5.0;
        double verticalBoost = 0.65;
        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), lookVec.field_72450_a * strength, verticalBoost, lookVec.field_72449_c * strength));
        player.field_70159_w = lookVec.field_72450_a * strength;
        player.field_70181_x = verticalBoost;
        player.field_70179_y = lookVec.field_72449_c * strength;
        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), lookVec.field_72450_a * strength, verticalBoost, lookVec.field_72449_c * strength));
        MinksDashAbility.activatedDashAbility(player.func_145782_y(), startPosition);
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onMinksTick(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)e.getEntityLiving();
            IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            if (data.getRace() != MinePieceRaces.MINKS) {
                return;
            }
            if (!hasActivatedDashAbility.contains(player.func_145782_y())) {
                return;
            }
            for (int i = 0; i < 7; ++i) {
                double offsetX = RANDOM.nextDouble() * 4.0 - 2.0;
                double offsetY = RANDOM.nextDouble() * 3.0 - 1.5;
                double offsetZ = RANDOM.nextDouble() * 4.0 - 2.0;
                double xPos = player.field_70165_t + offsetX;
                double yPos = player.field_70163_u + 0.5 + offsetY;
                double zPos = player.field_70161_v + offsetZ;
                EnumParticleTypes[] particleTypes = new EnumParticleTypes[]{ModParticles.MINKS_LINE, ModParticles.MINKS_ECROSS, ModParticles.MINKS_ECIRCLE};
                EnumParticleTypes particleType = particleTypes[RANDOM.nextInt(particleTypes.length)];
                ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(particleType, xPos, yPos, zPos));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data.getRaceID() != 3) {
            return;
        }
        if (!hasStartedDashAbility.containsKey(player.func_145782_y())) {
            return;
        }
        BlockPos pos = hasStartedDashAbility.get(player.func_145782_y());
        if (player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 8.0) {
            hasStartedDashAbility.remove(player.func_145782_y());
            double f1 = Math.cos(player.field_70177_z * ((float)Math.PI / 180));
            double f2 = Math.sin(player.field_70177_z * ((float)Math.PI / 180));
            double motionX = -f2 * 0.1;
            double motionY = 0.65;
            double motionZ = f1 * 0.1;
            player.field_70159_w = motionX;
            player.field_70179_y = motionZ;
            player.field_70133_I = true;
        } else if (event.phase == TickEvent.Phase.END) {
            World world = player.func_130014_f_();
            AxisAlignedBB boundingBox = new AxisAlignedBB(player.field_70165_t - 2.0, player.field_70163_u - 2.0, player.field_70161_v - 2.0, player.field_70165_t + 2.0, player.field_70163_u + 2.0, player.field_70161_v + 2.0);
            List entities = world.func_72872_a(Entity.class, boundingBox);
            for (Entity entity : entities) {
                if (entity == player) continue;
                entity.func_70097_a(DamageSource.field_76377_j, 8.0f);
            }
        }
    }

    @SubscribeEvent
    public void onMinksFall(LivingFallEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        event.setCanceled(MinksDashAbility.removePlayerFromDashLists(player.func_145782_y()));
    }

    private static boolean removePlayerFromDashLists(int entityId) {
        boolean deleted = false;
        if (hasActivatedDashAbility.contains(entityId)) {
            hasActivatedDashAbility.removeIf(integer -> integer == entityId);
            deleted = true;
        }
        if (hasStartedDashAbility.containsKey(entityId)) {
            Iterator<Map.Entry<Integer, BlockPos>> iterator = hasStartedDashAbility.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, BlockPos> entry = iterator.next();
                if (entry.getKey() != entityId) continue;
                iterator.remove();
            }
            deleted = true;
        }
        return deleted;
    }

    private static void activatedDashAbility(int entityID, BlockPos startingPosition) {
        hasStartedDashAbility.put(entityID, startingPosition);
        MinksDashAbility.setHasActivatedDashAbility(entityID);
    }

    private static void setHasActivatedDashAbility(int entityID) {
        hasActivatedDashAbility.add(entityID);
    }
}

