/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.human;

import fr.minepiece.client.particles.ModParticles;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.HumanRace;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PlayCustomSoundPacket;
import fr.minepiece.common.network.packets.races.SpawnParticlePacket;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HumanSkyWalkAbility
extends AbstractRaceAbility<HumanRace> {
    public static final HumanSkyWalkAbility INSTANCE = new HumanSkyWalkAbility();
    public static final ArrayList<Integer> hasActivatedAbility = new ArrayList();

    private HumanSkyWalkAbility() {
        super(true, 15, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/humain_pas_de_lune.png"), "human:sky_walk");
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        ModPackets.NETWORK.sendToAll((IMessage)new PlayCustomSoundPacket(PlayCustomSoundPacket.CustomSoundEnum.HUMAN_SKYWALK, 1.0f, 1.0f, false, 0, player.field_70165_t, player.field_70163_u, player.field_70161_v));
        ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(ModParticles.SKYWALK, player.field_70165_t, player.field_70163_u, player.field_70161_v));
        hasActivatedAbility.add(player.func_145782_y());
        Vec3d lookVec = player.func_70040_Z();
        double strength = 0.6;
        double verticalBoost = 0.8;
        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), lookVec.field_72450_a * strength, verticalBoost, lookVec.field_72449_c * strength));
        player.field_70159_w = lookVec.field_72450_a * strength;
        player.field_70181_x = verticalBoost;
        player.field_70179_y = lookVec.field_72449_c * strength;
        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), lookVec.field_72450_a * strength, verticalBoost, lookVec.field_72449_c * strength));
    }

    @SubscribeEvent
    public void onHumanFall(LivingFallEvent event) {
        EntityPlayerMP player;
        if (event.getEntityLiving() instanceof EntityPlayerMP && hasActivatedAbility.contains((player = (EntityPlayerMP)event.getEntityLiving()).func_145782_y())) {
            event.setCanceled(true);
            hasActivatedAbility.removeIf(integer -> integer.intValue() == player.func_145782_y());
        }
    }

    private ArrayList<Vec3d> getCircleCoordinates(Vec3d center, double radius, int amount) {
        ArrayList<Vec3d> coordinates = new ArrayList<Vec3d>(amount);
        for (int i = 0; i < amount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)amount;
            double x = center.field_72450_a + radius * Math.cos(angle);
            double y = center.field_72448_b;
            double z = center.field_72449_c + radius * Math.sin(angle);
            coordinates.add(new Vec3d(x, y, z));
        }
        return coordinates;
    }
}

