/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.human;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.HumanRace;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.CancelMovementPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HumanMetaliumAbility
extends AbstractRaceAbility<HumanRace> {
    public static final HumanMetaliumAbility INSTANCE = new HumanMetaliumAbility();
    public static HashMap<UUID, Integer> timeLeftPerPlayer = new HashMap();

    private HumanMetaliumAbility() {
        super(true, 50, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/humain_metal.png"), "human:metalium");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected boolean canExecute(EntityPlayerMP player) {
        if (!timeLeftPerPlayer.containsKey(player.func_110124_au())) {
            return super.canExecute(player);
        }
        return true;
    }

    @Override
    protected void removeEnergy(EntityPlayerMP player) {
        if (!timeLeftPerPlayer.containsKey(player.func_110124_au())) {
            super.removeEnergy(player);
        }
    }

    @Override
    protected void execute(final EntityPlayerMP player) {
        if (!timeLeftPerPlayer.containsKey(player.func_110124_au())) {
            this.enableMetalium(player);
        } else {
            this.disableMetalium(new ArrayList<UUID>(){
                {
                    this.add(player.func_110124_au());
                }
            });
        }
    }

    private void enableMetalium(EntityPlayerMP player) {
        IPlayerModifications data = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (data != null);
        if (Objects.equals(data.getPose(), "metalium")) {
            data.setPose("default");
        } else {
            data.setPose("metalium");
        }
        data.clientSync(player);
        timeLeftPerPlayer.put(player.func_110124_au(), 120);
        ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(player.func_110124_au(), true), player);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        timeLeftPerPlayer.forEach((entityId, timeLeft) -> timeLeftPerPlayer.put((UUID)entityId, timeLeft - 1));
        ArrayList<UUID> entityIDsToRemove = new ArrayList<UUID>();
        timeLeftPerPlayer.forEach((uuid, timeLeft) -> {
            EntityPlayer entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_152378_a(uuid);
            if (timeLeft <= 0 && entity instanceof EntityPlayerMP) {
                entityIDsToRemove.add((UUID)uuid);
            }
        });
        this.disableMetalium(entityIDsToRemove);
    }

    private void disableMetalium(ArrayList<UUID> entityIDsToRemove) {
        for (UUID uuid : entityIDsToRemove) {
            EntityPlayer entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_152378_a(uuid);
            if (!(entity instanceof EntityPlayerMP)) continue;
            this.resetPose((EntityPlayerMP)entity);
            timeLeftPerPlayer.remove(uuid);
            ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(entity.func_110124_au(), false), (EntityPlayerMP)entity);
        }
    }

    private void resetPose(EntityPlayerMP player) {
        IPlayerModifications data = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (data != null);
        data.setPose("default");
        data.clientSync(player);
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            float protectionPercent = this.getProtectionPercent(player);
            if (timeLeftPerPlayer.containsKey(player.func_145782_y())) {
                if (protectionPercent == 100.0f) {
                    event.setCanceled(true);
                }
                event.setAmount(event.getAmount() * (1.0f - protectionPercent / 100.0f));
                event.getEntity().field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70163_u, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        }
    }

    @SubscribeEvent
    public void onEntityKnockBack(LivingKnockBackEvent event) {
        EntityPlayerMP player;
        if (event.getEntity() instanceof EntityPlayerMP && timeLeftPerPlayer.containsKey((player = (EntityPlayerMP)event.getEntity()).func_145782_y())) {
            event.setCanceled(true);
        }
    }

    private float getProtectionPercent(EntityPlayerMP playerMP) {
        return 80.0f;
    }
}

