/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.giant;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.GiantRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.utils.shockwave.Ripple;
import fr.minepiece.common.utils.shockwave.RippleEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GiantSlamAbility
extends AbstractRaceAbility<GiantRace> {
    public static final GiantSlamAbility INSTANCE = new GiantSlamAbility();
    private static final ArrayList<Integer> midAirGiants = new ArrayList();
    private static final ArrayList<Integer> hasActivatedSlamAbility = new ArrayList();
    private static final HashMap<Integer, Long> activationTimes = new HashMap();
    private static final long ABILITY_TIMEOUT = 10000L;

    private GiantSlamAbility() {
        super(true, 45, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/geant_ecrasement.png"), "giant:slam");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        midAirGiants.add(player.func_145782_y());
        double f1 = Math.cos(player.field_70177_z * ((float)Math.PI / 180));
        double f2 = Math.sin(player.field_70177_z * ((float)Math.PI / 180));
        double blocsEnAvant = 0.3;
        PlayerUtils.changeVelocity(-f2 * blocsEnAvant, 1.4, f1 * blocsEnAvant, (EntityPlayer)player);
        hasActivatedSlamAbility.add(player.func_145782_y());
        activationTimes.put(player.func_145782_y(), System.currentTimeMillis());
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void giantTick(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)e.getEntityLiving();
            this.checkForTimeouts();
            IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            if (data.getRace() != MinePieceRaces.GIANT) {
                return;
            }
            if (!midAirGiants.contains(player.func_145782_y())) {
                return;
            }
            if (!player.func_70093_af()) {
                return;
            }
            Vec3d vec3d = Vec3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z);
            Vec3d vec3dModified = new Vec3d(vec3d.field_72450_a * 0.3, GiantSlamAbility.makeNegativeIfNot(vec3d.field_72448_b) * 1.4, vec3d.field_72449_c * 0.3);
            PlayerUtils.changeVelocity(vec3dModified, (EntityPlayer)player);
            data.setGiantSkill1(false);
            this.removePlayerFromMidAir((EntityPlayer)player);
        }
    }

    private void checkForTimeouts() {
        long currentTime = System.currentTimeMillis();
        ArrayList<Integer> playersToRemove = new ArrayList<Integer>();
        for (Map.Entry<Integer, Long> entry : activationTimes.entrySet()) {
            if (currentTime - entry.getValue() <= 10000L) continue;
            playersToRemove.add(entry.getKey());
        }
        for (Integer entityId : playersToRemove) {
            for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                if (player.func_145782_y() != entityId.intValue()) continue;
                this.removePlayerFromLists(player);
                break;
            }
            activationTimes.remove(entityId);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.SERVER)
    public void onGiantFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            assert (data != null);
            if (data.getRace() != MinePieceRaces.GIANT) {
                return;
            }
            if (hasActivatedSlamAbility.contains(player.func_145782_y())) {
                BlockPos centerPos = event.getEntity().func_180425_c().func_177982_a(0, -1, 0);
                int radius = 7;
                int radiusStart = 2;
                GiantSlamAbility.applyKnockbackToEntities(event.getEntityLiving(), centerPos, radius + radiusStart);
                Ripple ripple = new Ripple(event.getEntity().field_70170_p, centerPos, radiusStart, radius, 0.25, 2.0);
                ripple.run();
                RippleEvents.setRipple(ripple);
                this.removePlayerFromLists(player);
                event.setCanceled(true);
            }
        }
    }

    private void removePlayerFromLists(EntityPlayer player) {
        int entityID = player.func_145782_y();
        Iterator<Integer> i = hasActivatedSlamAbility.iterator();
        while (i.hasNext()) {
            if (i.next() != entityID) continue;
            i.remove();
        }
        this.removePlayerFromMidAir(player);
        activationTimes.remove(entityID);
    }

    private void removePlayerFromMidAir(EntityPlayer player) {
        int entityID = player.func_145782_y();
        Iterator<Integer> midAirGiantsIterator = midAirGiants.iterator();
        while (midAirGiantsIterator.hasNext()) {
            if (midAirGiantsIterator.next() != entityID) continue;
            midAirGiantsIterator.remove();
        }
    }

    private static void applyKnockbackToEntities(EntityLivingBase source, BlockPos centerPos, int radius) {
        double knockbackStrength = 1.4;
        float damageAmount = 5.0f;
        for (Entity entity : source.field_70170_p.func_72872_a(EntityLivingBase.class, source.func_174813_aQ().func_186662_g((double)radius))) {
            double dz;
            double dx;
            double distance;
            if (entity instanceof EntityPlayer && entity == source || !((distance = Math.sqrt((dx = entity.field_70165_t - (double)centerPos.func_177958_n()) * dx + (dz = entity.field_70161_v - (double)centerPos.func_177952_p()) * dz)) > 0.0)) continue;
            double knockbackX = dx / distance * knockbackStrength;
            double knockbackZ = dz / distance * knockbackStrength;
            entity.func_70024_g(knockbackX, 0.0, knockbackZ);
            entity.field_70181_x = 0.7;
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_184185_a(SoundEvents.field_187721_dT, 1.0f, 1.0f);
            }
            if (source.field_70170_p.field_72995_K || !(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase livingEntity = (EntityLivingBase)entity;
            livingEntity.func_70097_a(DamageSource.field_76377_j, damageAmount);
        }
    }

    public static double makeNegativeIfNot(double number) {
        return number >= 0.0 ? -number : number;
    }
}

