/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.giant;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.GiantRace;
import fr.minepiece.common.events.abilities.utils.BleedInformation;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.ParticleVortexPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GiantIkokuAbility
extends AbstractRaceAbility<GiantRace> {
    public static final GiantIkokuAbility INSTANCE = new GiantIkokuAbility();
    private HashMap<EntityLivingBase, BleedInformation> entitiesToDamage = new HashMap();
    public static ArrayList<ArrayList<Vec3d>> particlesToRender = new ArrayList();

    private GiantIkokuAbility() {
        super(true, 75, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/geant_ikoku.png"), "giant:ikoku");
        this.setCooldownInMilliseconds(15000);
    }

    @Override
    protected boolean canExecute(EntityPlayerMP player) {
        if (!this.hasSword(player)) {
            return false;
        }
        return super.canExecute(player);
    }

    private boolean hasSword(EntityPlayerMP player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemSword)) {
            TextComponentString msg = new TextComponentString("Il vous faut une \u00e9p\u00e9e en main pour pouvoir faire cette comp\u00e9tence");
            msg.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)msg);
            return false;
        }
        return true;
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        ArrayList<Vec3d> particleCoordinates = this.getParticleLocations((EntityPlayer)player);
        ParticleVortexPacket packet = new ParticleVortexPacket(particleCoordinates);
        ModPackets.NETWORK.sendToAll((IMessage)packet);
        this.dealDamage(player, particleCoordinates);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderParticles(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        int ticksPerParticleChange = 1;
        int currentTick = (int)player.field_70170_p.func_82737_E();
        if (currentTick % ticksPerParticleChange != 0) {
            return;
        }
        if (particlesToRender.isEmpty()) {
            return;
        }
        for (ArrayList<Vec3d> particleCoords : particlesToRender) {
            Iterator<Vec3d> iterator = particleCoords.iterator();
            for (int count = 0; iterator.hasNext() && count < 6; ++count) {
                Vec3d coordinates = iterator.next();
                Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.CLOUD, coordinates.field_72450_a, coordinates.field_72448_b, coordinates.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void bleedTick(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity().field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        if (e.getEntityLiving() != null && this.entitiesToDamage.containsKey(e.getEntityLiving())) {
            EntityLivingBase entity = e.getEntityLiving();
            BlockPos center = this.entitiesToDamage.get(entity).getVortexCenter();
            int bleedTick = this.entitiesToDamage.get(entity).getTicks();
            if (bleedTick > 2) {
                this.entitiesToDamage.remove(entity);
                return;
            }
            if (bleedTick == this.entitiesToDamage.get(entity).getStartTick()) {
                this.applyKnockbackInOppositeDirection(entity, center, 0.9f);
            }
            entity.func_70097_a(DamageSource.field_76377_j, 3.0f);
            this.entitiesToDamage.remove(entity);
            this.entitiesToDamage.put(entity, new BleedInformation(bleedTick + 1, center));
        }
    }

    @SideOnly(value=Side.SERVER)
    private void dealDamage(EntityPlayerMP sendingPlayer, ArrayList<Vec3d> particleCoordinates) {
        ArrayList<Integer> affectedPlayers = this.getAffectedEntities(particleCoordinates, (EntityPlayer)sendingPlayer);
        for (Integer affectedPlayerID : affectedPlayers) {
            EntityLivingBase affectedEntity = (EntityLivingBase)sendingPlayer.field_70170_p.func_73045_a(affectedPlayerID.intValue());
            if (affectedEntity == null) continue;
            this.addBleedingEntity(affectedEntity, sendingPlayer.func_180425_c());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderParticles(ArrayList<Vec3d> particleLocations) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (Vec3d coord : particleLocations) {
            world.func_175688_a(EnumParticleTypes.CLOUD, coord.field_72450_a, coord.field_72448_b, coord.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.SERVER)
    private ArrayList<Vec3d> getParticleLocations(EntityPlayer player) {
        ArrayList<Vec3d> particleList = new ArrayList<Vec3d>();
        int circlePoints = 10;
        double radius = 2.0;
        Vec3d playerLoc = player.func_174824_e(1.0f);
        World world = player.field_70170_p;
        Vec3d dir = player.func_70040_Z();
        double pitch = (player.field_70125_A + 90.0f) * ((float)Math.PI / 180);
        double yaw = -player.field_70177_z * ((float)Math.PI / 180);
        double increment = Math.PI * 2 / (double)circlePoints;
        double circlePointOffset = 4.0;
        int beamLength = 30;
        double radiusShrinkage = radius / (double)((beamLength + 2) / 2);
        for (int i = 0; i < beamLength; ++i) {
            for (int j = 0; j < circlePoints; ++j) {
                double angle = (double)j * increment + circlePointOffset;
                double x = radius * Math.cos((float)angle);
                double z = radius * Math.sin((float)angle);
                Vec3d vec = new Vec3d(x, 0.0, z);
                vec = vec.func_178789_a((float)pitch);
                vec = vec.func_178785_b((float)yaw);
                playerLoc = playerLoc.func_178787_e(vec);
                particleList.add(new Vec3d(playerLoc.field_72450_a, playerLoc.field_72448_b, playerLoc.field_72449_c));
                playerLoc = playerLoc.func_178788_d(vec);
            }
            if ((circlePointOffset += increment / 3.0) >= increment) {
                circlePointOffset = 0.0;
            }
            if ((radius -= radiusShrinkage) < 0.0) break;
            playerLoc = playerLoc.func_178787_e(dir);
        }
        return particleList;
    }

    @SideOnly(value=Side.SERVER)
    private ArrayList<Integer> getAffectedEntities(List<Vec3d> particleCoords, EntityPlayer originalPlayer) {
        ArrayList<Integer> entitiesIds = new ArrayList<Integer>();
        block0: for (Entity player : this.getEntitiesWithinRadius((Entity)originalPlayer, 30.0)) {
            if (!(player instanceof EntityLivingBase) || player == originalPlayer) continue;
            for (Vec3d coord : particleCoords) {
                if (entitiesIds.contains(player.func_145782_y())) continue block0;
                if (!this.isEntityWithinRadius(player, coord, 2.0)) continue;
                entitiesIds.add(player.func_145782_y());
            }
        }
        return entitiesIds;
    }

    @SideOnly(value=Side.SERVER)
    private boolean isEntityWithinRadius(Entity player, Vec3d targetCoordinates, double radius) {
        double radiusSquared;
        double distanceSquared = player.func_174791_d().func_72436_e(targetCoordinates);
        return distanceSquared <= (radiusSquared = radius * radius);
    }

    @SideOnly(value=Side.SERVER)
    private List<Entity> getEntitiesWithinRadius(Entity referenceEntity, double radius) {
        ArrayList<Entity> entitiesWithinRadius = new ArrayList<Entity>();
        World world = referenceEntity.func_130014_f_();
        Vec3d referencePos = referenceEntity.func_174791_d();
        for (Entity entity : world.field_72996_f) {
            Vec3d entityPos;
            double distance;
            if (entity == referenceEntity || !((distance = referencePos.func_72438_d(entityPos = entity.func_174791_d())) <= radius)) continue;
            entitiesWithinRadius.add(entity);
        }
        System.out.println("Found " + entitiesWithinRadius.size() + " close entities");
        return entitiesWithinRadius;
    }

    @SideOnly(value=Side.SERVER)
    private void addBleedingEntity(EntityLivingBase entity, BlockPos vortexCenter) {
        this.entitiesToDamage.put(entity, new BleedInformation(0, 0, vortexCenter));
    }

    @SideOnly(value=Side.SERVER)
    private void applyKnockbackInOppositeDirection(EntityLivingBase entity, BlockPos center, float strength) {
        if (entity == null || center == null || strength <= 0.0f) {
            return;
        }
        Vec3d entityPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vec3d blockPosVec = new Vec3d((double)center.func_177958_n() + 0.5, (double)center.func_177956_o() + 0.5, (double)center.func_177952_p() + 0.5);
        Vec3d directionVec = blockPosVec.func_178788_d(entityPos).func_72432_b();
        Vec3d knockbackVec = new Vec3d(-directionVec.field_72450_a, 0.0, -directionVec.field_72449_c);
        entity.func_70024_g(knockbackVec.field_72450_a * (double)strength, 0.75, knockbackVec.field_72449_c * (double)strength);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addIkokuToRender(ArrayList<Vec3d> particleCoords) {
        particlesToRender.add(particleCoords);
    }
}

