/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.giant;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.GiantRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GiantHitAbility
extends AbstractRaceAbility<GiantRace> {
    public static final GiantHitAbility INSTANCE = new GiantHitAbility();
    private final ArrayList<Integer> hasActivatedHitAbility = new ArrayList();

    private GiantHitAbility() {
        super(true, 25, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/geant_frappe.png"), "giant:hit");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        this.hasActivatedHitAbility.add(player.func_145782_y());
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187606_E, SoundCategory.PLAYERS, 1.0f, 2.25f);
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onBigHit(AttackEntityEvent event) {
        EntityPlayer player = this.getEntityPlayer(event);
        if (player == null) {
            return;
        }
        EntityLivingBase targetEntity = (EntityLivingBase)event.getTarget();
        float extraDamage = 6.0f;
        targetEntity.func_70606_j(targetEntity.func_110143_aJ() - extraDamage);
        double knockbackStrength = 1.0;
        targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f))) * knockbackStrength, 0.5, (double)MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockbackStrength);
        targetEntity.field_70160_al = true;
        targetEntity.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187926_gz, SoundCategory.PLAYERS, 1.0f, 0.75f);
        this.hasActivatedHitAbility.removeIf(id -> id.intValue() == event.getEntityLiving().func_145782_y());
    }

    private EntityPlayer getEntityPlayer(AttackEntityEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return null;
        }
        if (!this.hasActivatedHitAbility.contains(event.getEntityLiving().func_145782_y())) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data.getRace() != MinePieceRaces.GIANT) {
            return null;
        }
        return player;
    }
}

