/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.fishman;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.FishmanRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PlayCustomSoundPacket;
import fr.minepiece.common.network.packets.races.SpawnParticlePacket;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FishmanSharkPalmAbility
extends AbstractRaceAbility<FishmanRace> {
    public static final FishmanSharkPalmAbility INSTANCE = new FishmanSharkPalmAbility();
    private final ArrayList<Integer> hasActivatedHitAbility = new ArrayList();
    private final ArrayList<UUID> midAirEntities = new ArrayList();

    private FishmanSharkPalmAbility() {
        super(true, 75, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/poisson_paume.png"), "fishman:shark_palm");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        this.hasActivatedHitAbility.add(player.func_145782_y());
        ModPackets.NETWORK.sendToAll((IMessage)new PlayCustomSoundPacket(PlayCustomSoundPacket.CustomSoundEnum.FISHMAN_DROP, 1.0f, 0.2f, false, 0, player.field_70165_t, player.field_70163_u, player.field_70161_v));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.SERVER)
    public void onBigHit(AttackEntityEvent event) {
        EntityPlayer player = this.getEntityPlayer(event);
        if (player == null) {
            return;
        }
        EntityLivingBase targetEntity = (EntityLivingBase)event.getTarget();
        float extraDamage = 5.0f;
        double knockbackStrength = 2.0;
        targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), extraDamage);
        targetEntity.field_70159_w = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f))) * knockbackStrength;
        targetEntity.field_70179_y = (double)MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockbackStrength;
        targetEntity.field_70181_x = 1.1;
        targetEntity.field_70160_al = true;
        event.setCanceled(true);
        this.midAirEntities.add(targetEntity.func_110124_au());
        ModPackets.NETWORK.sendToAll((IMessage)new PlayCustomSoundPacket(PlayCustomSoundPacket.CustomSoundEnum.FISHMAN_DROP, 1.0f, 1.5f, false, 0, targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v));
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(EnumParticleTypes.WATER_DROP, targetEntity.field_70165_t + random.nextDouble(), targetEntity.field_70163_u + random.nextDouble(), targetEntity.field_70161_v + random.nextDouble()));
        }
        this.hasActivatedHitAbility.removeIf(id -> id.intValue() == event.getEntityLiving().func_145782_y());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ArrayList<UUID> uuidsToRemove = new ArrayList<UUID>();
        for (UUID uuid : this.midAirEntities) {
            Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(uuid);
            if (entity == null) continue;
            Random random = new Random();
            ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(EnumParticleTypes.WATER_DROP, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(EnumParticleTypes.WATER_DROP, entity.field_70165_t + random.nextDouble(), entity.field_70163_u + random.nextDouble(), entity.field_70161_v + random.nextDouble()));
            ModPackets.NETWORK.sendToAll((IMessage)new SpawnParticlePacket(EnumParticleTypes.WATER_DROP, entity.field_70165_t + random.nextDouble(), entity.field_70163_u + random.nextDouble() + 0.5, entity.field_70161_v + random.nextDouble()));
            if (!entity.field_70122_E) continue;
            uuidsToRemove.add(uuid);
        }
        for (UUID uuid : uuidsToRemove) {
            this.midAirEntities.remove(uuid);
        }
    }

    private EntityPlayer getEntityPlayer(AttackEntityEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return null;
        }
        if (!this.hasActivatedHitAbility.contains(event.getEntityLiving().func_145782_y())) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data.getRace() != MinePieceRaces.FISHMAN) {
            return null;
        }
        return player;
    }
}

