/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.cyborg;

import fr.minepiece.client.particles.vfx.implementations.ParticleCCBlur;
import fr.minepiece.client.particles.vfx.implementations.ParticleFire;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.CyborgRace;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.CyborgWavePacket;
import fr.minepiece.common.network.packets.races.OpenOverheatGuiPacket;
import fr.minepiece.common.utils.helpers.AABBHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyborgOverheatAbility
extends AbstractRaceAbility<CyborgRace> {
    public static final CyborgOverheatAbility INSTANCE = new CyborgOverheatAbility();
    private static HashMap<CyborgWavePacket, Double> wavesToRender = new HashMap();
    private HashMap<CyborgWavePacket, Set<EntityLivingBase>> damagedEntities = new HashMap();
    private final Random RANDOM = new Random();

    private CyborgOverheatAbility() {
        super(true, 150, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/cyborg_surchauffe.png"), "cyborg:overheat");
        this.setCooldownInMilliseconds(600000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        CyborgWavePacket packet = new CyborgWavePacket(player.func_70005_c_(), new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        CyborgOverheatAbility.addWaveToRender(packet);
        ModPackets.NETWORK.sendToAll((IMessage)packet);
        ModPackets.NETWORK.sendTo((IMessage)new OpenOverheatGuiPacket(), player);
    }

    public void onServerTick() {
        ArrayList<CyborgWavePacket> packetsToRemove = new ArrayList<CyborgWavePacket>();
        for (CyborgWavePacket packet2 : wavesToRender.keySet()) {
            double length = wavesToRender.get(packet2);
            length = length <= 1.0 ? (length += (double)0.0125f) : (length += (double)0.12f);
            wavesToRender.put(packet2, length);
            if (length > 5.0) {
                packetsToRemove.add(packet2);
                continue;
            }
            this.dealDamage(packet2, length);
        }
        packetsToRemove.forEach(packet -> {
            wavesToRender.remove(packet);
            this.damagedEntities.remove(packet);
        });
    }

    @SideOnly(value=Side.SERVER)
    private void dealDamage(CyborgWavePacket packet, double length) {
        EntityPlayerMP sendingPlayer = PlayerUtils.getServerPlayerByUsername(packet.getUsername());
        assert (sendingPlayer != null);
        int playerID = sendingPlayer.func_145782_y();
        World world = sendingPlayer.field_70170_p;
        List<AxisAlignedBB> boundingBoxes = AABBHelper.generateSphereBoundingBoxes(packet, length, 40);
        Iterator iterator = world.field_72996_f.iterator();
        Set affectedEntities = this.damagedEntities.computeIfAbsent(packet, k -> new HashSet());
        while (iterator.hasNext()) {
            EntityLivingBase entityLivingBase;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof EntityLivingBase) || affectedEntities.contains(entity) || entity.func_145782_y() == playerID || !AABBHelper.doesEntityIntersectWithBoundingBoxes((Entity)(entityLivingBase = (EntityLivingBase)entity), boundingBoxes)) continue;
            affectedEntities.add(entityLivingBase);
        }
        for (EntityLivingBase entityLivingBase : affectedEntities) {
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)sendingPlayer), 25.0f);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.side.isClient()) {
            this.onClientTick(event);
        } else if (event.side.isServer()) {
            this.onServerTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<CyborgWavePacket> packetsToRemove = new ArrayList<CyborgWavePacket>();
        for (CyborgWavePacket packet2 : wavesToRender.keySet()) {
            double length = wavesToRender.get(packet2);
            length = length <= 1.0 ? (length += (double)0.0125f) : (length += (double)0.12f);
            wavesToRender.put(packet2, length);
            if (length > 5.0) {
                packetsToRemove.add(packet2);
                continue;
            }
            this.renderWave(packet2, length);
        }
        packetsToRemove.forEach(packet -> {
            wavesToRender.remove(packet);
            this.damagedEntities.remove(packet);
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        for (CyborgWavePacket packet : wavesToRender.keySet()) {
            double length = wavesToRender.get(packet);
            this.renderWave(packet, length);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWave(CyborgWavePacket packet, double radius) {
        float[] colors = CyborgOverheatAbility.hexToFloatArray(13749449);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Vec3d view = new Vec3d(manager.field_78730_l, manager.field_78731_m, manager.field_78728_n);
        Vec3d center = packet.getCenter();
        int steps = 16;
        double stepAngle = Math.PI * 2 / (double)steps;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < steps; ++i) {
            double lat0 = Math.PI * (-0.5 + (double)i / (double)steps);
            double z0 = Math.sin(lat0);
            double zr0 = Math.cos(lat0);
            double lat1 = Math.PI * (-0.5 + (double)(i + 1) / (double)steps);
            double z1 = Math.sin(lat1);
            double zr1 = Math.cos(lat1);
            for (int j = 0; j < steps; ++j) {
                double lng0 = stepAngle * (double)j;
                double x0 = Math.cos(lng0);
                double y0 = Math.sin(lng0);
                double lng1 = stepAngle * (double)(j + 1);
                double x1 = Math.cos(lng1);
                double y1 = Math.sin(lng1);
                Vec3d p1 = new Vec3d(center.field_72450_a + x0 * zr0 * radius, center.field_72448_b + y0 * zr0 * radius, center.field_72449_c + z0 * radius);
                Vec3d p2 = new Vec3d(center.field_72450_a + x1 * zr0 * radius, center.field_72448_b + y1 * zr0 * radius, center.field_72449_c + z0 * radius);
                Vec3d p3 = new Vec3d(center.field_72450_a + x1 * zr1 * radius, center.field_72448_b + y1 * zr1 * radius, center.field_72449_c + z1 * radius);
                Vec3d p4 = new Vec3d(center.field_72450_a + x0 * zr1 * radius, center.field_72448_b + y0 * zr1 * radius, center.field_72449_c + z1 * radius);
                bufferBuilder.func_181662_b(p1.field_72450_a - view.field_72450_a, p1.field_72448_b - view.field_72448_b, p1.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
                bufferBuilder.func_181662_b(p2.field_72450_a - view.field_72450_a, p2.field_72448_b - view.field_72448_b, p2.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
                bufferBuilder.func_181662_b(p3.field_72450_a - view.field_72450_a, p3.field_72448_b - view.field_72448_b, p3.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
                bufferBuilder.func_181662_b(p4.field_72450_a - view.field_72450_a, p4.field_72448_b - view.field_72448_b, p4.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        this.doWaveParticles(packet, radius, 3);
    }

    @SideOnly(value=Side.CLIENT)
    private void doWaveParticles(CyborgWavePacket packet, double radius, int particleCount) {
        double z;
        double y;
        double x;
        double phi;
        double theta;
        int i;
        Random rand = new Random();
        particleCount = (radius *= 1.25) < 1.0 ? 1 : particleCount;
        for (i = 0; i < particleCount / 3; ++i) {
            theta = rand.nextDouble() * 2.0 * Math.PI;
            phi = rand.nextDouble() * Math.PI;
            x = packet.getCenter().field_72450_a + radius * Math.sin(phi) * Math.cos(theta);
            y = packet.getCenter().field_72448_b + radius * Math.sin(phi) * Math.sin(theta);
            z = packet.getCenter().field_72449_c + radius * Math.cos(phi);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleCCBlur((World)Minecraft.func_71410_x().field_71441_e, x, y, z).setLife(20).setScale(3.0f).setColor(13749449).setGravity(0.0f));
        }
        for (i = 0; i < particleCount / 3; ++i) {
            theta = rand.nextDouble() * 2.0 * Math.PI;
            phi = rand.nextDouble() * Math.PI;
            x = packet.getCenter().field_72450_a + radius * Math.sin(phi) * Math.cos(theta);
            y = packet.getCenter().field_72448_b + radius * Math.sin(phi) * Math.sin(theta);
            z = packet.getCenter().field_72449_c + radius * Math.cos(phi);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleFire((World)Minecraft.func_71410_x().field_71441_e, x, y, z).setLife(20).setScale(3.0f).setGravity(0.0f));
        }
        for (i = 0; i < particleCount / 3; ++i) {
            theta = rand.nextDouble() * 2.0 * Math.PI;
            phi = rand.nextDouble() * Math.PI;
            x = packet.getCenter().field_72450_a + radius * Math.sin(phi) * Math.cos(theta);
            y = packet.getCenter().field_72448_b + radius * Math.sin(phi) * Math.sin(theta);
            z = packet.getCenter().field_72449_c + radius * Math.cos(phi);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleCCBlur((World)Minecraft.func_71410_x().field_71441_e, x, y, z).setLife(60).setScale(3.0f).setColor(0x474545).setGravity(0.1f));
        }
        double ratio = radius / 5.0;
        int color = this.interpolateColor(0, 0x6B6B6B, (float)ratio);
        int ringParticleCount = (int)(Math.PI * (2.0 * radius) * 3.0);
        for (int i2 = 0; i2 < ringParticleCount; ++i2) {
            double theta2 = (double)i2 * (Math.PI * 2 / (double)ringParticleCount);
            double phi2 = 1.5707963267948966;
            double x2 = packet.getCenter().field_72450_a + radius * Math.sin(phi2) * Math.cos(theta2);
            double y2 = packet.getCenter().field_72448_b;
            double z2 = packet.getCenter().field_72449_c + radius * Math.sin(phi2) * Math.sin(theta2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleCCBlur((World)Minecraft.func_71410_x().field_71441_e, x2, y2, z2).setLife(2).setScale(3.0f).setColor(color).setGravity(0.0f));
        }
    }

    public static float[] hexToFloatArray(int hexColor) {
        float red = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColor & 0xFF) / 255.0f;
        float alpha = 0.75f;
        return new float[]{red, green, blue, alpha};
    }

    public int interpolateColor(int startColor, int endColor, float ratio) {
        int r1 = startColor >> 16 & 0xFF;
        int g1 = startColor >> 8 & 0xFF;
        int b1 = startColor & 0xFF;
        int r2 = endColor >> 16 & 0xFF;
        int g2 = endColor >> 8 & 0xFF;
        int b2 = endColor & 0xFF;
        int r = (int)((float)r1 + ratio * (float)(r2 - r1));
        int g = (int)((float)g1 + ratio * (float)(g2 - g1));
        int b = (int)((float)b1 + ratio * (float)(b2 - b1));
        return r << 16 | g << 8 | b;
    }

    public static void addWaveToRender(CyborgWavePacket waveToRender) {
        wavesToRender.put(waveToRender, 0.0);
    }
}

