/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.cyborg;

import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgBeamPacket;
import fr.minepiece.common.api.races.CyborgRace;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PlayCustomSoundPacket;
import fr.minepiece.common.network.packets.races.CyborgLaserSyncingPacket;
import fr.minepiece.common.network.packets.races.DamagePacket;
import fr.minepiece.common.utils.helpers.AABBHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyborgLaserAbility
extends AbstractRaceAbility<CyborgRace> {
    public static final CyborgLaserAbility INSTANCE = new CyborgLaserAbility();
    public static HashMap<CyborgBeamPacket, Double> beamsToRender = new HashMap();
    public HashMap<CyborgBeamPacket, Set<Entity>> damagedEntities = new HashMap();

    private CyborgLaserAbility() {
        super(true, 30, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/cyborg_laser.png"), "cyborg:laser");
        this.setCooldownInMilliseconds(5000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        ModPackets.NETWORK.sendToAll((IMessage)new PlayCustomSoundPacket(PlayCustomSoundPacket.CustomSoundEnum.CYBORG_LASER, 1.0f, 1.0f, false, 0, player.field_70165_t, player.field_70163_u, player.field_70161_v));
        int beamDistance = 30;
        this.makeBeam((EntityPlayer)player, beamDistance);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInputUpdate(InputUpdateEvent event) {
        if (this.shouldCancelMovement(event.getEntityPlayer())) {
            MovementInput movementInput = event.getMovementInput();
            movementInput.field_192832_b = 0.0f;
            movementInput.field_78902_a = 0.0f;
            movementInput.field_78901_c = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean shouldCancelMovement(EntityPlayer player) {
        for (CyborgBeamPacket packet : beamsToRender.keySet()) {
            if (!Objects.equals(packet.getUsername(), player.func_70005_c_())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ArrayList<CyborgBeamPacket> packetsToRemove = new ArrayList<CyborgBeamPacket>();
        for (CyborgBeamPacket packet2 : beamsToRender.keySet()) {
            double length = beamsToRender.get(packet2);
            if (event.phase == TickEvent.Phase.END) {
                length = length <= 1.0 ? (length += (double)0.015f) : (length += (double)3.6f);
            }
            EntityPlayerMP sendingPlayer = PlayerUtils.getServerPlayerByUsername(packet2.getUsername());
            if (length <= 1.0) {
                packet2.setStartEnd(this.getNewStart((EntityPlayer)sendingPlayer), this.getNewEnd((EntityPlayer)sendingPlayer, packet2.getBeamLength()));
            }
            beamsToRender.put(packet2, length);
            if (length > packet2.getBeamLength()) {
                packetsToRemove.add(packet2);
                continue;
            }
            this.dealDamage(packet2, length);
        }
        packetsToRemove.forEach(packet -> {
            beamsToRender.remove(packet);
            this.damagedEntities.remove(packet);
        });
        ModPackets.NETWORK.sendToAll((IMessage)new CyborgLaserSyncingPacket(beamsToRender));
    }

    private void dealDamage(CyborgBeamPacket packet, double length) {
        Set damagedEntitiesForBeam = this.damagedEntities.computeIfAbsent(packet, k -> new HashSet());
        EntityPlayerMP player = PlayerUtils.getServerPlayerByUsername(packet.getUsername());
        assert (player != null);
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        for (Entity entity : world.field_72996_f) {
            if (damagedEntitiesForBeam.contains(entity) || entity == player || !AABBHelper.doesEntityIntersectWithBoundingBoxes(entity, AABBHelper.getSegmentBoundingBoxes(packet.getStart(), packet.getEnd(), length, packet.getGlowRadius(), 15)) || !(entity instanceof EntityLivingBase)) continue;
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)DamagePacket.Types.CYBORG_LASER_BEAM.getDamage());
            damagedEntitiesForBeam.add(entity);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        for (Map.Entry<CyborgBeamPacket, Double> entry : beamsToRender.entrySet()) {
            CyborgBeamPacket packet = entry.getKey();
            double length = entry.getValue();
            CyborgLaserAbility.renderBeam(packet.getStart(), packet.getEnd(), packet.getColors(), packet.getBeamRadius(), packet.getGlowRadius(), length);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBeam(Vec3d start, Vec3d end, float[] colors, double beamRadius, double glowRadius, double beamLength) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        CyborgLaserAbility.setupRenderState();
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Vec3d view = new Vec3d(manager.field_78730_l, manager.field_78731_m, manager.field_78728_n);
        Vec3d dir = end.func_178788_d(start).func_72432_b();
        Vec3d right = new Vec3d(-dir.field_72449_c, 0.0, dir.field_72450_a).func_72432_b().func_186678_a(beamRadius);
        Vec3d up = dir.func_72431_c(right).func_72432_b().func_186678_a(beamRadius);
        end = start.func_178787_e(dir.func_186678_a(beamLength));
        Vec3d outerRight = right.func_186678_a(glowRadius);
        Vec3d outerUp = up.func_186678_a(glowRadius);
        double steps = 16.0;
        double stepAngle = Math.PI * 2 / steps;
        List<Vec3d> innerRingStart = CyborgLaserAbility.computeCircleVertices(start, right, up, steps, stepAngle);
        List<Vec3d> innerRingEnd = CyborgLaserAbility.computeCircleVertices(end, right, up, steps, stepAngle);
        CyborgLaserAbility.renderQuadStrip(innerRingStart, innerRingEnd, colors, view, bufferBuilder, tessellator);
        CyborgLaserAbility.renderCap(start, innerRingStart, colors, view, colors[3], colors[3], bufferBuilder, tessellator);
        CyborgLaserAbility.renderCap(end, innerRingEnd, colors, view, colors[3], colors[3], bufferBuilder, tessellator);
        List<Vec3d> glowRingStart = CyborgLaserAbility.computeCircleVertices(start, outerRight, outerUp, steps, stepAngle);
        List<Vec3d> glowRingEnd = CyborgLaserAbility.computeCircleVertices(end, outerRight, outerUp, steps, stepAngle);
        float glowAlpha = 0.2f;
        CyborgLaserAbility.renderQuadStripGlow(glowRingStart, glowRingEnd, colors, view, glowAlpha, bufferBuilder, tessellator);
        CyborgLaserAbility.renderCap(start, glowRingStart, colors, view, glowAlpha, glowAlpha, bufferBuilder, tessellator);
        CyborgLaserAbility.renderCap(end, glowRingEnd, colors, view, glowAlpha, glowAlpha, bufferBuilder, tessellator);
        CyborgLaserAbility.cleanupRenderState();
        GlStateManager.func_179121_F();
        CyborgLaserAbility.doBeamParticles(beamLength, beamRadius, start, dir, up, right);
    }

    @SideOnly(value=Side.CLIENT)
    private static List<Vec3d> computeCircleVertices(Vec3d center, Vec3d vecA, Vec3d vecB, double steps, double stepAngle) {
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>();
        int i = 0;
        while ((double)i <= steps) {
            double angle = stepAngle * (double)i;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            Vec3d offset = vecA.func_186678_a(cos).func_178787_e(vecB.func_186678_a(sin));
            vertices.add(center.func_178787_e(offset));
            ++i;
        }
        return vertices;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderCap(Vec3d center, List<Vec3d> ringVertices, float[] colors, Vec3d view, float centerAlpha, float ringAlpha, BufferBuilder buffer, Tessellator tessellator) {
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(center.field_72450_a - view.field_72450_a, center.field_72448_b - view.field_72448_b, center.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], centerAlpha).func_181675_d();
        for (Vec3d v : ringVertices) {
            buffer.func_181662_b(v.field_72450_a - view.field_72450_a, v.field_72448_b - view.field_72448_b, v.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], ringAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderQuadStrip(List<Vec3d> ring1, List<Vec3d> ring2, float[] colors, Vec3d view, BufferBuilder buffer, Tessellator tessellator) {
        buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
        int count = ring1.size();
        for (int i = 0; i < count; ++i) {
            Vec3d v1 = ring1.get(i);
            Vec3d v2 = ring2.get(i);
            buffer.func_181662_b(v1.field_72450_a - view.field_72450_a, v1.field_72448_b - view.field_72448_b, v1.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
            buffer.func_181662_b(v2.field_72450_a - view.field_72450_a, v2.field_72448_b - view.field_72448_b, v2.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], colors[3]).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderQuadStripGlow(List<Vec3d> ring1, List<Vec3d> ring2, float[] colors, Vec3d view, float glowAlpha, BufferBuilder buffer, Tessellator tessellator) {
        buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
        int count = ring1.size();
        for (int i = 0; i < count; ++i) {
            Vec3d v1 = ring1.get(i);
            Vec3d v2 = ring2.get(i);
            buffer.func_181662_b(v1.field_72450_a - view.field_72450_a, v1.field_72448_b - view.field_72448_b, v1.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], glowAlpha).func_181675_d();
            buffer.func_181662_b(v2.field_72450_a - view.field_72450_a, v2.field_72448_b - view.field_72448_b, v2.field_72449_c - view.field_72449_c).func_181666_a(colors[0], colors[1], colors[2], glowAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void cleanupRenderState() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    private static void setupRenderState() {
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    private static void doBeamParticles(double beamLength, double beamRadius, Vec3d start, Vec3d dir, Vec3d up, Vec3d right) {
        double particleDensity = beamLength > 1.0 ? 0.2 : 1.0;
        Random rand = new Random();
        int numParticles = (int)(1.0 / particleDensity);
        for (int i = 0; i < numParticles; ++i) {
            double xOffset = (rand.nextDouble() - 0.5) * beamRadius * 10.0 * 2.0;
            double yOffset = (rand.nextDouble() - 0.5) * beamRadius * 10.0 * 2.0;
            double zOffset = (rand.nextDouble() - 0.5) * beamRadius * 10.0 * 2.0;
            Vec3d particlePos = start.func_178787_e(dir.func_186678_a(beamLength)).func_178787_e(right.func_186678_a(xOffset)).func_178787_e(up.func_186678_a(yOffset)).func_178787_e(dir.func_72431_c(right).func_186678_a(zOffset));
            ParticleFirework.Spark particle = new ParticleFirework.Spark((World)Minecraft.func_71410_x().field_71441_e, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0, Minecraft.func_71410_x().field_71452_i);
            particle.func_187146_c(Integer.parseInt("ece781", 16));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    private Vec3d getNewStart(EntityPlayer player) {
        Vec3d lookVec = player.func_70040_Z();
        return player.func_174824_e(1.0f).func_72441_c(0.0, -0.5, 0.0).func_178787_e(lookVec.func_186678_a(1.0));
    }

    private Vec3d getNewEnd(EntityPlayer player, double beamDistance) {
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f).func_72441_c(0.0, -0.5, 0.0).func_178787_e(lookVec.func_186678_a(1.0));
        return start.func_178787_e(lookVec.func_186678_a(beamDistance));
    }

    public void makeBeam(EntityPlayer player, double beamDistance) {
        System.out.println("bem start");
        double BEAM_RADIUS = 0.25;
        double GLOW_RADIUS = 1.25;
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f).func_72441_c(0.0, -0.5, 0.0).func_178787_e(lookVec.func_186678_a(1.0));
        Vec3d end = start.func_178787_e(lookVec.func_186678_a(beamDistance));
        float[] colors = new float[]{0.9255f, 0.9059f, 0.5059f, 1.0f};
        beamsToRender.put(new CyborgBeamPacket(player.func_70005_c_(), start, end, colors, 0.25, 1.25, beamDistance), 0.0);
    }

    public static void addNewBeamToRender(CyborgBeamPacket packet) {
        beamsToRender.put(packet, 0.0);
    }
}

