/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.cyborg;

import fr.minepiece.client.particles.vfx.implementations.ParticleFire;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.races.CyborgRace;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.races.CyborgFlameThrowerPacket;
import fr.minepiece.common.utils.helpers.AABBHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyborgFlamethrowerAbility
extends AbstractRaceAbility<CyborgRace> {
    public static final CyborgFlamethrowerAbility INSTANCE = new CyborgFlamethrowerAbility();
    public HashMap<Integer, Integer> ticksLeftPerPlayer = new HashMap();
    public static ArrayList<ArrayList<ParticleFire>> particlesToRender = new ArrayList();
    private long lastTickProcessed = -1L;

    private CyborgFlamethrowerAbility() {
        super(true, 45, new ResourceLocation("minepiece", "textures/gui/new/composants/races/abilities/cyborg_lance_flamme.png"), "cyborg:flamethrower");
        this.setCooldownInMilliseconds(20000);
    }

    @Override
    protected void execute(EntityPlayerMP player) {
        this.ticksLeftPerPlayer.put(player.func_145782_y(), 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldRender(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int ticksPerParticleChange = 1;
        int currentTick = (int)player.field_70170_p.func_82737_E();
        if ((long)currentTick == this.lastTickProcessed) {
            return;
        }
        if (currentTick % ticksPerParticleChange != 0) {
            return;
        }
        if (particlesToRender.isEmpty()) {
            this.lastTickProcessed = currentTick;
            return;
        }
        ArrayList<ArrayList<ParticleFire>> arrayList = particlesToRender;
        synchronized (arrayList) {
            Iterator<ArrayList<ParticleFire>> outerIterator = particlesToRender.iterator();
            while (outerIterator.hasNext()) {
                ArrayList<ParticleFire> particleFires = outerIterator.next();
                if (particleFires.isEmpty()) {
                    outerIterator.remove();
                    continue;
                }
                ArrayList<ParticleFire> particlesToProcess = new ArrayList<ParticleFire>();
                int count = Math.min(4, particleFires.size());
                for (int i = 0; i < count; ++i) {
                    particlesToProcess.add(particleFires.get(0));
                    particleFires.remove(0);
                }
                for (ParticleFire flame : particlesToProcess) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flame);
                }
                if (!particleFires.isEmpty()) continue;
                outerIterator.remove();
            }
            this.lastTickProcessed = currentTick;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.ticksLeftPerPlayer.containsKey(event.player.func_145782_y())) {
            return;
        }
        for (Integer playerID : this.ticksLeftPerPlayer.keySet()) {
            if (playerID.intValue() != event.player.func_145782_y()) continue;
            this.ticksLeftPerPlayer.compute(playerID, (id, currentTicks) -> currentTicks - 1);
            if (this.ticksLeftPerPlayer.get(playerID) > 0) {
                this.sendFireUnit(event.player);
                continue;
            }
            this.ticksLeftPerPlayer.remove(playerID);
        }
    }

    private void sendFireUnit(EntityPlayer sendingPlayer) {
        if (!this.playerIsOnCorrectTick(sendingPlayer)) {
            return;
        }
        FlameUnit unit = this.getFlameUnit(sendingPlayer);
        CyborgFlameThrowerPacket packet = new CyborgFlameThrowerPacket(unit.coordinates);
        ModPackets.NETWORK.sendToAll((IMessage)packet);
        unit.dealDamage(sendingPlayer.field_70170_p, sendingPlayer.func_145782_y());
    }

    private FlameUnit getFlameUnit(EntityPlayer sendingPlayer) {
        double posX = sendingPlayer.field_70165_t;
        double posY = sendingPlayer.field_70163_u;
        double posZ = sendingPlayer.field_70161_v;
        float pitch = sendingPlayer.field_70125_A;
        float yaw = sendingPlayer.field_70177_z;
        double offsetX = -Math.sin(Math.toRadians(yaw));
        double offsetY = -Math.sin(Math.toRadians(pitch));
        double offsetZ = Math.cos(Math.toRadians(yaw));
        double startX = posX + (offsetX *= 0.85);
        double startY = posY + (offsetY *= 1.0);
        double startZ = posZ + (offsetZ *= 0.85);
        return new FlameUnit(new Vec3d(startX, startY + 1.0, startZ), 7.0, 5.0, sendingPlayer.field_70125_A, sendingPlayer.field_70177_z, sendingPlayer.field_70170_p);
    }

    private boolean playerIsOnCorrectTick(EntityPlayer sendingPlayer) {
        int ticksLeft = this.ticksLeftPerPlayer.get(sendingPlayer.func_145782_y());
        if (ticksLeft < 1) {
            this.ticksLeftPerPlayer.remove(sendingPlayer.func_145782_y());
            return false;
        }
        int flamesPerSecond = 6;
        int ticksPerParticleChange = 20 / flamesPerSecond;
        return sendingPlayer.field_70170_p.func_82737_E() % (long)ticksPerParticleChange == 0L;
    }

    public static class FlameUnit {
        private final Vec3d start;
        public final ArrayList<Vec3d> coordinates;
        private final double length;
        private final double density;
        private final double pitch;
        private final double yaw;
        private final Random random;
        private final World world;

        public FlameUnit(Vec3d start, double length, double density, double pitch, double yaw, World world) {
            this.start = start;
            this.length = length;
            this.density = density;
            this.pitch = pitch;
            this.yaw = yaw;
            this.random = new Random();
            this.world = world;
            this.coordinates = this.calculateCoordinates(this.start, this.length, this.density, this.pitch, this.yaw);
        }

        public static ArrayList<ParticleFire> getFlameParticles(World world, ArrayList<Vec3d> coordinates) {
            ArrayList<ParticleFire> particles = new ArrayList<ParticleFire>();
            ArrayList<Integer> colors = FlameUnit.calculateColorGradient(coordinates.size() / 4, 0xFDFDFB, 16382385, 16317520, 16338944, 15017767);
            Random random = new Random();
            if (coordinates.size() > colors.size()) {
                while (coordinates.size() > colors.size()) {
                    coordinates.remove(coordinates.size() - 1);
                }
            } else if (colors.size() > coordinates.size()) {
                while (colors.size() > coordinates.size()) {
                    colors.remove(colors.size() - 1);
                }
            }
            for (int i = 0; i < coordinates.size(); ++i) {
                Vec3d particleCoordinate = coordinates.get(i);
                int color = colors.get(i);
                particles.add((ParticleFire)new ParticleFire(world, particleCoordinate.field_72450_a, particleCoordinate.field_72448_b, particleCoordinate.field_72449_c).setMainColor(color, colors.get(Math.min(i + colors.size() / 3, colors.size() - 1)), (float)i / (float)coordinates.size()).setScale(2.0f * (2.0f + (float)i / (float)coordinates.size())).setGravity(0.0f).setAlphaFading(1.0f).setLife(15));
                if (i % (coordinates.size() / 4) != 0) continue;
                particles.add((ParticleFire)new ParticleFire(world, particleCoordinate.field_72450_a + (double)(random.nextFloat() * 2.0f) - 1.0, particleCoordinate.field_72448_b + (double)(random.nextFloat() * 2.0f) - 1.0, particleCoordinate.field_72449_c + (double)(random.nextFloat() * 2.0f) - 1.0).setScale(2.2f).setGravity(5.0E-4f).setAlphaFading(1.0f).setLife(15));
            }
            return particles;
        }

        @SideOnly(value=Side.SERVER)
        public void dealDamage(World world, int playerID) {
            ArrayList<Vec3d> clippedCoordinates = this.removeEveryN(this.coordinates, 3);
            List<AxisAlignedBB> boundingBoxes = AABBHelper.createBoundingBoxes(clippedCoordinates);
            Iterator iterator = world.field_72996_f.iterator();
            HashSet<EntityLivingBase> damagedEntities = new HashSet<EntityLivingBase>();
            while (iterator.hasNext()) {
                EntityLivingBase entityLivingBase;
                Entity entity = (Entity)iterator.next();
                if (!(entity instanceof EntityLivingBase) || damagedEntities.contains(entity) || entity.func_145782_y() == playerID || !AABBHelper.doesEntityIntersectWithBoundingBoxes((Entity)(entityLivingBase = (EntityLivingBase)entity), boundingBoxes)) continue;
                damagedEntities.add(entityLivingBase);
            }
            for (EntityLivingBase entityLivingBase : damagedEntities) {
                entityLivingBase.func_70097_a(DamageSource.field_76372_a, 2.0f);
                entityLivingBase.func_70015_d(3);
            }
        }

        private ArrayList<Vec3d> calculateCoordinates(Vec3d start, double length, double density, double pitch, double yaw) {
            int numberOfParticles = (int)(length * density);
            ArrayList<Vec3d> coordinates = new ArrayList<Vec3d>(Collections.singletonList(start));
            Vec3d end = this.calculateEndPoint(start, length, pitch, yaw);
            double pitchRad = -Math.toRadians(pitch);
            double yawRad = -Math.toRadians(yaw);
            Random random = new Random();
            double middleX = (start.field_72450_a + end.field_72450_a) * 0.5;
            double middleY = (start.field_72448_b + end.field_72448_b) * 0.5;
            double middleZ = (start.field_72449_c + end.field_72449_c) * 0.5;
            double randomXOffset = (double)(random.nextDouble() > 0.5 ? 1 : -1) * (random.nextDouble() * 0.75 + 0.5);
            double randomYOffset = (double)(random.nextDouble() > 0.5 ? 1 : -1) * (random.nextDouble() * 0.5 + 0.25);
            Vec3d middle = new Vec3d(middleX, middleY, middleZ);
            middle = middle.func_178789_a((float)(-pitchRad)).func_178785_b((float)(-yawRad));
            middle = middle.func_72441_c(randomXOffset, randomYOffset, 0.0);
            middle = middle.func_178785_b((float)yawRad).func_178789_a((float)pitchRad);
            for (int step = 0; step <= numberOfParticles; ++step) {
                double progress = (double)step / (double)numberOfParticles;
                double reverseProgress = 1.0 - progress;
                double x = reverseProgress * reverseProgress * start.field_72450_a + 2.0 * reverseProgress * progress * middle.field_72450_a + progress * progress * end.field_72450_a;
                double y = reverseProgress * reverseProgress * start.field_72448_b + 2.0 * reverseProgress * progress * middle.field_72448_b + progress * progress * end.field_72448_b;
                double z = reverseProgress * reverseProgress * start.field_72449_c + 2.0 * reverseProgress * progress * middle.field_72449_c + progress * progress * end.field_72449_c;
                if ((double)step % length == 0.0 && this.rayCastCheck(start, new Vec3d(x, y, z), this.world)) break;
                coordinates.add(new Vec3d(x += random.nextDouble() * 0.4 + 0.05, y += random.nextDouble() * 0.4 + 0.05, z += random.nextDouble() * 0.4 + 0.05));
            }
            return coordinates;
        }

        private boolean rayCastCheck(Vec3d start, Vec3d end, World world) {
            RayTraceResult result = world.func_147447_a(start, end, true, true, false);
            return result != null && result.field_72313_a == RayTraceResult.Type.BLOCK;
        }

        private static ArrayList<Integer> calculateColorGradient(int steps, int ... colors) {
            ArrayList<Integer> gradientColors = new ArrayList<Integer>();
            if (colors.length < 2) {
                throw new IllegalArgumentException("At least two colors are required to create a gradient.");
            }
            for (int i = 0; i < colors.length - 1; ++i) {
                int colorStart = colors[i];
                int colorEnd = colors[i + 1];
                int startRed = colorStart >> 16 & 0xFF;
                int startGreen = colorStart >> 8 & 0xFF;
                int startBlue = colorStart & 0xFF;
                int endRed = colorEnd >> 16 & 0xFF;
                int endGreen = colorEnd >> 8 & 0xFF;
                int endBlue = colorEnd & 0xFF;
                double redStep = (double)(endRed - startRed) / (double)steps;
                double greenStep = (double)(endGreen - startGreen) / (double)steps;
                double blueStep = (double)(endBlue - startBlue) / (double)steps;
                for (int j = 0; j < steps; ++j) {
                    int currentRed = (int)((double)startRed + (double)j * redStep);
                    int currentGreen = (int)((double)startGreen + (double)j * greenStep);
                    int currentBlue = (int)((double)startBlue + (double)j * blueStep);
                    int currentColor = currentRed << 16 | currentGreen << 8 | currentBlue;
                    gradientColors.add(currentColor);
                }
            }
            gradientColors.add(colors[colors.length - 1]);
            return gradientColors;
        }

        private Vec3d calculateEndPoint(Vec3d start, double length, double pitch, double yaw) {
            double pitchRad = -Math.toRadians(pitch);
            double yawRad = -Math.toRadians(yaw);
            double endX = start.field_72450_a + length * Math.sin(yawRad) * Math.cos(pitchRad);
            double endY = start.field_72448_b + length * Math.sin(pitchRad);
            double endZ = start.field_72449_c + length * Math.cos(yawRad) * Math.cos(pitchRad);
            return new Vec3d(endX, endY, endZ);
        }

        private ArrayList<Vec3d> removeEveryN(ArrayList<Vec3d> arrayToSort, int n) {
            ArrayList<Vec3d> clippedArray = new ArrayList<Vec3d>();
            int i = 0;
            for (Vec3d vec3d : arrayToSort) {
                if (i++ % n == n - 1) continue;
                clippedArray.add(vec3d);
            }
            return clippedArray;
        }

        public ArrayList<Vec3d> getCoordinates() {
            return this.coordinates;
        }
    }
}

