/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities.races.cyborg;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class CyborgBeamPacket {
    private String username;
    private Vec3d start;
    private Vec3d end;
    private float[] colors;
    private double beamRadius;
    private double glowRadius;
    private double beamLength;

    public CyborgBeamPacket() {
    }

    public CyborgBeamPacket(String username) {
        this.username = username;
    }

    public CyborgBeamPacket(String name, Vec3d start, Vec3d end, float[] colors, double beamRadius, double glowRadius, double beamLength) {
        this.username = name;
        this.start = start;
        this.end = end;
        this.colors = colors;
        this.beamRadius = beamRadius;
        this.glowRadius = glowRadius;
        this.beamLength = beamLength;
    }

    public void fromBytes(ByteBuf buf) {
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
        double startX = buf.readDouble();
        double startY = buf.readDouble();
        double startZ = buf.readDouble();
        this.start = new Vec3d(startX, startY, startZ);
        double endX = buf.readDouble();
        double endY = buf.readDouble();
        double endZ = buf.readDouble();
        this.end = new Vec3d(endX, endY, endZ);
        this.colors = new float[4];
        this.colors[0] = buf.readFloat();
        this.colors[1] = buf.readFloat();
        this.colors[2] = buf.readFloat();
        this.colors[3] = buf.readFloat();
        this.beamRadius = buf.readDouble();
        this.glowRadius = buf.readDouble();
        this.beamLength = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
        buf.writeDouble(this.start.field_72450_a);
        buf.writeDouble(this.start.field_72448_b);
        buf.writeDouble(this.start.field_72449_c);
        buf.writeDouble(this.end.field_72450_a);
        buf.writeDouble(this.end.field_72448_b);
        buf.writeDouble(this.end.field_72449_c);
        buf.writeFloat(this.colors[0]);
        buf.writeFloat(this.colors[1]);
        buf.writeFloat(this.colors[2]);
        buf.writeFloat(this.colors[3]);
        buf.writeDouble(this.beamRadius);
        buf.writeDouble(this.glowRadius);
        buf.writeDouble(this.beamLength);
    }

    public String getUsername() {
        return this.username;
    }

    public Vec3d getStart() {
        return this.start;
    }

    public Vec3d getEnd() {
        return this.end;
    }

    public float[] getColors() {
        return this.colors;
    }

    public double getBeamRadius() {
        return this.beamRadius;
    }

    public double getGlowRadius() {
        return this.glowRadius;
    }

    public double getBeamLength() {
        return this.beamLength;
    }

    public void setStart(Vec3d start) {
        this.start = start;
    }

    public void setEnd(Vec3d end) {
        this.end = end;
    }

    public void setStartEnd(Vec3d start, Vec3d end) {
        this.start = start;
        this.end = end;
    }
}

