/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities;

import fr.minepiece.common.api.abilities.AbstractAbility;
import fr.minepiece.common.api.races.IMinePieceRace;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractRaceAbility<T extends IMinePieceRace>
extends AbstractAbility {
    protected int energyCost;

    public AbstractRaceAbility(ResourceLocation icon, String id) {
        super(icon, id);
    }

    protected AbstractRaceAbility(boolean isEventHandler, int energyCost, ResourceLocation icon, String id) {
        super(isEventHandler, icon, id);
        this.energyCost = energyCost;
    }

    @Override
    protected void executeAndManageCooldown(EntityPlayerMP player) {
        if (!this.canExecute(player)) {
            return;
        }
        this.removeEnergy(player);
        this.execute(player);
        this.postExecution(player);
    }

    @Override
    @Deprecated
    protected boolean canExecute(EntityPlayerMP player) {
        if (this.doesNotHaveEnoughEnergy(player)) {
            return false;
        }
        return this.cooldownCheck(player);
    }

    @Override
    protected void postExecution(EntityPlayerMP player) {
        IMinePieceCooldown cooldowns = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        assert (cooldowns != null);
        cooldowns.setCooldown(this.id, System.currentTimeMillis() + (long)this.cooldownInMilliseconds);
        cooldowns.clientSync(player);
    }

    protected void removeEnergy(EntityPlayerMP player) {
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        assert (data != null);
        data.getRace().getInstance().consumeEnergy((EntityPlayer)player, this.energyCost);
        data.clientSync(player);
        IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        assert (stats != null);
        stats.clientSync(player);
    }

    private boolean cooldownCheck(EntityPlayerMP player) {
        IMinePieceCooldown cooldowns = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        assert (cooldowns != null);
        long cooldown = cooldowns.getCooldown(this.id);
        if (cooldown == -1L) {
            return true;
        }
        return cooldown < System.currentTimeMillis();
    }

    private boolean doesNotHaveEnoughEnergy(EntityPlayerMP player) {
        IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        assert (stats != null);
        return !stats.hasEnoughEnergy(this.energyCost);
    }
}

