/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public abstract class AbstractAbility {
    protected int cooldownInMilliseconds;
    protected ResourceLocation icon;
    protected String id;

    public AbstractAbility(ResourceLocation icon, String id) {
        this(false, icon, id);
    }

    protected AbstractAbility(boolean isEventHandler, ResourceLocation icon, String id) {
        if (isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.icon = icon;
        this.id = id;
    }

    protected abstract void execute(EntityPlayerMP var1);

    public void serverExecution(EntityPlayerMP playerMP) {
        this.executeAndManageCooldown(playerMP);
    }

    protected void executeAndManageCooldown(EntityPlayerMP player) {
        if (!this.canExecute(player)) {
            return;
        }
        this.execute(player);
        this.postExecution(player);
    }

    protected abstract boolean canExecute(EntityPlayerMP var1);

    protected abstract void postExecution(EntityPlayerMP var1);

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public void setCooldownInMilliseconds(int cooldownInMilliseconds) {
        this.cooldownInMilliseconds = cooldownInMilliseconds;
    }

    public void setCooldownInTicks(int cooldownInTicks) {
        this.cooldownInMilliseconds = cooldownInTicks * 50;
    }

    public int getCooldownInMilliseconds() {
        return this.cooldownInMilliseconds;
    }
}

