/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.api.abilities;

import fr.minepiece.common.api.abilities.AbstractAbility;
import fr.minepiece.common.api.abilities.AbstractRaceAbility;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgFlamethrowerAbility;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgLaserAbility;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgOverheatAbility;
import fr.minepiece.common.api.abilities.races.fishman.FishmanSharkPalmAbility;
import fr.minepiece.common.api.abilities.races.fishman.FishmanWaterDropsAbility;
import fr.minepiece.common.api.abilities.races.fishman.FishmanWaterSharkAbility;
import fr.minepiece.common.api.abilities.races.giant.GiantHitAbility;
import fr.minepiece.common.api.abilities.races.giant.GiantIkokuAbility;
import fr.minepiece.common.api.abilities.races.giant.GiantSlamAbility;
import fr.minepiece.common.api.abilities.races.human.HumanMetaliumAbility;
import fr.minepiece.common.api.abilities.races.human.HumanPiedOuraganAbility;
import fr.minepiece.common.api.abilities.races.human.HumanSkyWalkAbility;
import fr.minepiece.common.api.abilities.races.minks.MinksDashAbility;
import fr.minepiece.common.api.abilities.races.minks.MinksExplosionAbility;
import fr.minepiece.common.api.abilities.races.minks.MinksSulongAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaFriendBoostAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaHealthAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaJumpAbility;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.CapabilityHelper;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public enum AbilitiesEnum {
    HUMAN_SKY_WALK(HumanSkyWalkAbility.INSTANCE.id, "skills.race.human.sky_walk.description", HumanSkyWalkAbility.INSTANCE.icon, HumanSkyWalkAbility.INSTANCE, AbilityType.RACE),
    HUMAN_METALIUM(HumanMetaliumAbility.INSTANCE.id, "skills.race.human.metalium.description", HumanMetaliumAbility.INSTANCE.icon, HumanMetaliumAbility.INSTANCE, AbilityType.RACE),
    HUMAN_PIED_OURAGAN(HumanPiedOuraganAbility.INSTANCE.id, "skills.race.human.pied.description", HumanPiedOuraganAbility.INSTANCE.icon, HumanPiedOuraganAbility.INSTANCE, AbilityType.RACE),
    TONTATTA_JUMP(TontattaJumpAbility.INSTANCE.id, "skills.race.tontatta.jump.description", TontattaJumpAbility.INSTANCE.icon, TontattaJumpAbility.INSTANCE, AbilityType.RACE),
    TONTATTA_HEAL(TontattaHealthAbility.INSTANCE.id, "skills.race.tontatta.heal.description", TontattaHealthAbility.INSTANCE.icon, TontattaHealthAbility.INSTANCE, AbilityType.RACE),
    TONTATTA_FRIEND_BOOST(TontattaFriendBoostAbility.INSTANCE.id, "skills.race.tontatta.friend_boost.description", TontattaFriendBoostAbility.INSTANCE.icon, TontattaFriendBoostAbility.INSTANCE, AbilityType.RACE),
    FISHMAN_WATER_DROPS(FishmanWaterDropsAbility.INSTANCE.id, "skills.race.fishman.drops.description", FishmanWaterDropsAbility.INSTANCE.icon, FishmanWaterDropsAbility.INSTANCE, AbilityType.RACE),
    FISHMAN_WATER_SHARK(FishmanWaterSharkAbility.INSTANCE.id, "skills.race.fishman.shark.description", FishmanWaterSharkAbility.INSTANCE.icon, FishmanWaterSharkAbility.INSTANCE, AbilityType.RACE),
    FISHMAN_SHARK_PALM(FishmanSharkPalmAbility.INSTANCE.id, "skills.race.fishman.palm.description", FishmanSharkPalmAbility.INSTANCE.icon, FishmanSharkPalmAbility.INSTANCE, AbilityType.RACE),
    MINKS_EXPLOSION(MinksExplosionAbility.INSTANCE.id, "skills.race.minks.explosion.description", MinksExplosionAbility.INSTANCE.icon, MinksExplosionAbility.INSTANCE, AbilityType.RACE),
    MINKS_DASH(MinksDashAbility.INSTANCE.id, "skills.race.minks.dash.description", MinksDashAbility.INSTANCE.icon, MinksDashAbility.INSTANCE, AbilityType.RACE),
    MINKS_SULONG(MinksSulongAbility.INSTANCE.id, "skills.race.minks.sulong.description", MinksSulongAbility.INSTANCE.icon, MinksSulongAbility.INSTANCE, AbilityType.RACE),
    GIANT_SLAM(GiantSlamAbility.INSTANCE.id, "skills.race.giant.slam.description", GiantSlamAbility.INSTANCE.icon, GiantSlamAbility.INSTANCE, AbilityType.RACE),
    GIANT_IKOKU(GiantIkokuAbility.INSTANCE.id, "skills.race.giant.ikoku.description", GiantIkokuAbility.INSTANCE.icon, GiantIkokuAbility.INSTANCE, AbilityType.RACE),
    GIANT_HIT(GiantHitAbility.INSTANCE.id, "skills.race.giant.hit.description", GiantHitAbility.INSTANCE.icon, GiantHitAbility.INSTANCE, AbilityType.RACE),
    CYBORG_LASER(CyborgLaserAbility.INSTANCE.id, "skills.race.cyborg.laser.description", CyborgLaserAbility.INSTANCE.icon, CyborgLaserAbility.INSTANCE, AbilityType.RACE),
    CYBORG_FLAMETHROWER(CyborgFlamethrowerAbility.INSTANCE.id, "skills.race.cyborg.flamethrower.description", CyborgFlamethrowerAbility.INSTANCE.icon, CyborgFlamethrowerAbility.INSTANCE, AbilityType.RACE),
    CYBORG_OVERHEAT(CyborgOverheatAbility.INSTANCE.id, "skills.race.cyborg.overheat.description", CyborgOverheatAbility.INSTANCE.icon, CyborgOverheatAbility.INSTANCE, AbilityType.RACE);

    private final String name;
    private final String description;
    private final ResourceLocation icon;
    private final AbstractAbility ability;
    private final AbilityType type;

    private AbilitiesEnum(String name, String description, ResourceLocation icon, AbstractAbility ability, AbilityType type) {
        this.name = name;
        this.ability = ability;
        this.icon = icon;
        this.description = description;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public AbstractAbility getAbility() {
        return this.ability;
    }

    public AbilityType getType() {
        return this.type;
    }

    public static ArrayList<AbstractRaceAbility> getRaceAbilities(MinePieceRaces race) {
        ArrayList<AbstractRaceAbility> abilities = new ArrayList<AbstractRaceAbility>();
        for (AbilitiesEnum value : AbilitiesEnum.values()) {
            if (!value.getType().equals((Object)AbilityType.RACE) || !value.getName().split(":")[0].equals(race.getName())) continue;
            abilities.add((AbstractRaceAbility)value.getAbility());
        }
        return abilities;
    }

    @Nullable
    public static AbilitiesEnum getAbilityFromName(String name) {
        for (AbilitiesEnum value : AbilitiesEnum.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }

    public void unlock(EntityPlayerMP player) {
        IMinePieceData data = CapabilityHelper.getPlayerData((EntityPlayer)player);
        data.addSkill(this.getName());
        data.clientSync(player);
    }

    public static enum AbilityType {
        RACE,
        WEAPON;

    }
}

