/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.visual;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TemperatureZoneRenderer {
    private static final List<ZoneRender> ZONES_TO_RENDER = new ArrayList<ZoneRender>();

    public static void addZoneToRender(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int durationTicks, double temperature) {
        ZONES_TO_RENDER.add(new ZoneRender(minX, minY, minZ, maxX, maxY, maxZ, durationTicks, temperature));
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        if (ZONES_TO_RENDER.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        long currentTime = mc.field_71441_e.func_82737_E();
        Iterator<ZoneRender> iterator = ZONES_TO_RENDER.iterator();
        while (iterator.hasNext()) {
            ZoneRender zone = iterator.next();
            if (!zone.isExpired(currentTime)) continue;
            iterator.remove();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (ZoneRender zone : ZONES_TO_RENDER) {
            float t;
            float blue;
            float green;
            float red;
            long timeLeft = zone.endTime - currentTime;
            float alpha = Math.min(1.0f, (float)timeLeft / 20.0f);
            if (zone.temperature <= 0.0) {
                red = 0.0f;
                green = 0.0f;
                blue = 1.0f;
            } else if (zone.temperature >= 40.0) {
                red = 1.0f;
                green = 0.0f;
                blue = 0.0f;
            } else if (zone.temperature < 20.0) {
                t = (float)(zone.temperature / 20.0);
                red = 0.0f;
                green = t;
                blue = 1.0f - t;
            } else {
                red = t = (float)((zone.temperature - 20.0) / 20.0);
                green = 1.0f - t;
                blue = 0.0f;
            }
            TemperatureZoneRenderer.drawBoxEdges(tessellator, buffer, zone.box, red, green, blue, alpha);
            TemperatureZoneRenderer.drawBoxFaces(tessellator, buffer, zone.box, red, green, blue, alpha * 0.2f);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void drawBoxEdges(Tessellator tessellator, BufferBuilder buffer, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        GlStateManager.func_187441_d((float)2.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawBoxFaces(Tessellator tessellator, BufferBuilder buffer, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void clearAllZones() {
        ZONES_TO_RENDER.clear();
    }

    @SubscribeEvent
    public static void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        TemperatureZoneRenderer.clearAllZones();
    }

    private static class ZoneRender {
        final AxisAlignedBB box;
        final long endTime;
        final double temperature;

        ZoneRender(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int durationTicks, double temperature) {
            this.box = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
            this.endTime = Minecraft.func_71410_x().field_71441_e.func_82737_E() + (long)durationTicks;
            this.temperature = temperature;
        }

        boolean isExpired(long currentTime) {
            return currentTime > this.endTime;
        }
    }
}

