/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.util.Color;

public class RenderUtils {
    private static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    public static final String ABSORPTION_COLOR = "#d4af37";
    public static final String ABSORPTION_POISON_COLOR = "#c5d117";
    public static final String ABSORPTION_WITHER_COLOR = "#70590d";
    public static final double[] HEARTS = new double[]{20.0, 40.0, 60.0, 80.0, 100.0, 120.0, 140.0, 180.0, 200.0, 220.0, 240.0, 260.0};
    public static final String[] NORMAL_COLORS = new String[]{"#ff0000", "#ee8100", "#e5ce00", "#00da00", "#0c9df1", "#b486ff", "#ec8afb", "#fb8bad", "#fbd78b", "#03efec", "#b7e7fd", "#ededed"};
    public static final String[] POISONED_COLORS = new String[]{"#00ff00", "#619613", "#86cf1a", "#6aa514", "#5a8c11", "#68a114", "#72b116", "#70ad16", "#94e221", "#80c619", "#96e326", "#9ee536"};
    public static final String[] WITHERED_COLORS = new String[]{"#555555", "#474747", "#434343", "#3e3e3e", "#4e4e4e", "#898989", "#898989", "#898989", "#898989", "#484848", "#9d9d9d", "#adadad"};

    public static void drawTexturedModalRect(float x, float y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.func_175174_a(x, y, textureX, textureY, width, height);
    }

    public static int getWidth(double d1, double d2) {
        if (d1 >= d2) {
            return 77;
        }
        int w = 77;
        double d3 = Math.max((double)w * d1 / d2, 0.0);
        return (int)Math.ceil(d3);
    }

    public static int getStringLength(String s) {
        return FONT_RENDERER.func_78256_a(s);
    }

    public static void drawStringOnHUD(String string, int xOffset, int yOffset, int color) {
        FONT_RENDERER.func_175065_a(string, (float)(xOffset += 2), (float)(yOffset += 2), color, true);
    }

    public static Color getColor(double d2, int effect) {
        String[] colorCodes = null;
        if (effect == 16) {
            colorCodes = NORMAL_COLORS;
        } else if (effect == 52) {
            colorCodes = POISONED_COLORS;
        } else if (effect == 88) {
            colorCodes = WITHERED_COLORS;
        }
        return RenderUtils.hex2Color(colorCodes[RenderUtils.getHeartMulti(d2)]);
    }

    public static int colorToText(Color c) {
        return (c.getRed() << 16) + (c.getGreen() << 8) + c.getBlue();
    }

    public static void color2Gl(Color c) {
        RenderUtils.color2Gl(c, 1.0f);
    }

    public static void color2Gl(Color c, float a) {
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)a);
    }

    public static int getHeartMulti(double health) {
        if (health <= 20.0) {
            return 0;
        }
        if (health >= HEARTS[HEARTS.length - 2]) {
            return HEARTS.length - 1;
        }
        return (int)Math.ceil(health / 20.0) - 1;
    }

    public static Color hex2Color(String colorStr) {
        if (!RenderUtils.isValidHexColor(colorStr)) {
            return new Color();
        }
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16).intValue(), Integer.valueOf(colorStr.substring(3, 5), 16).intValue(), Integer.valueOf(colorStr.substring(5, 7), 16).intValue());
    }

    public static boolean isValidHexColor(String hexColor) {
        if (!hexColor.startsWith("#")) {
            return false;
        }
        if ((hexColor = hexColor.substring(1)).length() == 0 || hexColor.charAt(0) != '-' && Character.digit(hexColor.charAt(0), 16) == -1) {
            return false;
        }
        if (hexColor.length() == 1 && hexColor.charAt(0) == '-') {
            return false;
        }
        for (int i = 1; i < hexColor.length(); ++i) {
            if (Character.digit(hexColor.charAt(i), 16) != -1) continue;
            return false;
        }
        return true;
    }

    public static float roundTo(float number, int decimal) {
        double tempDecimal = 1.0;
        for (int i = 0; i < decimal; ++i) {
            tempDecimal *= 10.0;
        }
        return (float)((double)Math.round((double)number * tempDecimal) / tempDecimal);
    }
}

