/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.texture;

import fr.minepiece.client.render.texture.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.compress.utils.IOUtils;

public class TextureManager {
    private static final TextureManager INSTANCE = new TextureManager();
    private static final ResourceLocation CLASSIC_PIXELS = new ResourceLocation("minepiece", "textures/skin/base/classicpixels.png");
    private final Map<ResourceLocation, BufferedImage> textureCache = new ConcurrentHashMap<ResourceLocation, BufferedImage>();
    private final Map<UUID, BufferedImage> playerBaseSkins = new ConcurrentHashMap<UUID, BufferedImage>();

    private TextureManager() {
    }

    public static TextureManager getInstance() {
        return INSTANCE;
    }

    @Nullable
    public BufferedImage getPlayerBaseSkin(UUID playerUUID) {
        return this.playerBaseSkins.get(playerUUID);
    }

    public void loadPlayerBaseSkin(UUID playerUUID, String skinURL) {
        try {
            BufferedImage skinImage = ImageIO.read(new URL(skinURL));
            if (this.isSlimSkin(skinImage)) {
                skinImage = ImageProcessor.mergeImages(this.getSkinTexture(CLASSIC_PIXELS), skinImage);
            }
            this.playerBaseSkins.put(playerUUID, skinImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPlayerDefaultSkin(UUID playerUUID, boolean isSlim) {
        ResourceLocation defaultSkinTexture = isSlim ? new ResourceLocation("textures/entity/alex.png") : new ResourceLocation("textures/entity/steve.png");
        BufferedImage skinImage = this.getSkinTexture(defaultSkinTexture);
        if (skinImage != null) {
            if (isSlim) {
                skinImage = ImageProcessor.mergeImages(this.getSkinTexture(CLASSIC_PIXELS), skinImage);
            }
            this.playerBaseSkins.put(playerUUID, skinImage);
        }
    }

    @Nullable
    public BufferedImage getSkinTexture(ResourceLocation location) {
        return TextureManager.getBufferedImageSkin(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImageSkin(ResourceLocation resourceLocation) {
        Minecraft mc = Minecraft.func_71410_x();
        BufferedImage bufferedImage = null;
        InputStream inputStream = null;
        try {
            ITextureObject skintex = mc.func_110434_K().func_110581_b(resourceLocation);
            if (skintex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData imageData = (ThreadDownloadImageData)skintex;
                bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imageData, (String[])new String[]{"bufferedImage", "field_110560_d", "bpr.h"});
            } else {
                inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
                bufferedImage = ImageIO.read(inputStream);
            }
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return bufferedImage;
    }

    private boolean isSlimSkin(BufferedImage skin) {
        int slimCheckX = 56;
        int slimCheckY = 32;
        if (skin.getWidth() <= slimCheckX || skin.getHeight() <= slimCheckY) {
            return false;
        }
        int alpha = skin.getRGB(slimCheckX, slimCheckY) >> 24 & 0xFF;
        return alpha == 0;
    }

    public void clearCache() {
        this.textureCache.clear();
    }
}

