/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.texture;

import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class TextureCache {
    private static final TextureCache INSTANCE = new TextureCache();
    private final Map<UUID, CachedTexture> playerTextures = new ConcurrentHashMap<UUID, CachedTexture>();

    private TextureCache() {
    }

    public static TextureCache getInstance() {
        return INSTANCE;
    }

    public CachedTexture getCachedTexture(UUID playerUUID, int modificationHash) {
        CachedTexture cached = this.playerTextures.get(playerUUID);
        if (cached != null && cached.isValid(modificationHash)) {
            return cached;
        }
        return null;
    }

    public void cacheTexture(UUID playerUUID, ResourceLocation location, int modificationHash, BufferedImage image) {
        CachedTexture oldTexture = this.playerTextures.get(playerUUID);
        if (oldTexture != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(oldTexture.location);
        }
        this.playerTextures.put(playerUUID, new CachedTexture(location, modificationHash, image));
    }

    public void removeCachedTexture(UUID playerUUID) {
        CachedTexture cached = this.playerTextures.remove(playerUUID);
        if (cached != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(cached.location);
        }
    }

    public void clearCache() {
        for (CachedTexture texture : this.playerTextures.values()) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(texture.location);
        }
        this.playerTextures.clear();
    }

    public static class CachedTexture {
        public final ResourceLocation location;
        public final int modificationHash;
        public final long timestamp;
        public final BufferedImage image;

        public CachedTexture(ResourceLocation location, int modificationHash, BufferedImage image) {
            this.location = location;
            this.modificationHash = modificationHash;
            this.timestamp = System.currentTimeMillis();
            this.image = image;
        }

        public boolean isValid(int currentModificationHash) {
            return this.modificationHash == currentModificationHash;
        }
    }
}

