/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.texture;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import fr.minepiece.client.render.texture.AsyncTextureGenerator;
import fr.minepiece.client.render.texture.ImageProcessor;
import fr.minepiece.client.render.texture.TextureCache;
import fr.minepiece.client.render.texture.TextureManager;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="minepiece", value={Side.CLIENT})
public class OptimizedPlayerTextureBakery {
    public static final OptimizedPlayerTextureBakery INSTANCE = new OptimizedPlayerTextureBakery();
    private final TextureCache textureCache = TextureCache.getInstance();
    private final Map<UUID, Integer> armourerTextureHashes = new ConcurrentHashMap<UUID, Integer>();
    private final AsyncTextureGenerator textureGenerator = AsyncTextureGenerator.getInstance();
    private final Map<UUID, CompletableFuture<ResourceLocation>> pendingTextures = new ConcurrentHashMap<UUID, CompletableFuture<ResourceLocation>>();
    private ResourceLocation normalTexture;

    private OptimizedPlayerTextureBakery() {
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            INSTANCE.clearCaches();
        }
    }

    public void clearCaches() {
        this.textureCache.clearCache();
        this.armourerTextureHashes.clear();
        this.pendingTextures.clear();
    }

    @SubscribeEvent
    public static void onEntityTrack(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityPlayer().field_70170_p.field_72995_K && event.getTarget() instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)event.getTarget();
            INSTANCE.requestPlayerSkinLoading(player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        INSTANCE.requestPlayerSkinLoading(player);
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof AbstractClientPlayer) {
            UUID uuid = event.player.func_110124_au();
            OptimizedPlayerTextureBakery.INSTANCE.textureCache.removeCachedTexture(uuid);
            OptimizedPlayerTextureBakery.INSTANCE.armourerTextureHashes.remove(uuid);
            OptimizedPlayerTextureBakery.INSTANCE.pendingTextures.remove(uuid);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPreHigh(RenderPlayerEvent.Pre event) {
        if (!(event.getEntityPlayer() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        OptimizedPlayerTextureBakery.INSTANCE.normalTexture = player.func_110306_p();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPreLow(RenderPlayerEvent.Pre event) {
        UUID playerUUID;
        TextureCache.CachedTexture cachedTexture;
        int cachedArmourerHash;
        if (!(event.getEntityPlayer() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        ResourceLocation armourerLoc = player.func_110306_p();
        int currentArmourerHash = armourerLoc.hashCode();
        if (currentArmourerHash != (cachedArmourerHash = OptimizedPlayerTextureBakery.INSTANCE.armourerTextureHashes.getOrDefault(player.func_110124_au(), 0).intValue()) || INSTANCE.hasPlayerModificationsChanged(player.func_110124_au(), (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null))) {
            OptimizedPlayerTextureBakery.INSTANCE.armourerTextureHashes.put(player.func_110124_au(), currentArmourerHash);
            BufferedImage armourerTexture = TextureManager.getInstance().getSkinTexture(armourerLoc);
            BufferedImage baseSkin = TextureManager.getInstance().getPlayerBaseSkin(player.func_110124_au());
            if (baseSkin != null && armourerTexture != null) {
                BufferedImage deltaTexture = ImageProcessor.computeTextureDelta(baseSkin, armourerTexture);
                INSTANCE.generatePlayerTexture(player, deltaTexture);
            }
        }
        if ((cachedTexture = OptimizedPlayerTextureBakery.INSTANCE.textureCache.getCachedTexture(playerUUID = player.func_110124_au(), ((IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null)).computeHash())) != null) {
            OptimizedPlayerTextureBakery.setPlayerTexture(player, cachedTexture.location);
        } else {
            CompletableFuture<ResourceLocation> pendingTexture = OptimizedPlayerTextureBakery.INSTANCE.pendingTextures.get(playerUUID);
            if (pendingTexture != null && pendingTexture.isDone() && !pendingTexture.isCompletedExceptionally()) {
                try {
                    ResourceLocation textureLocation = pendingTexture.get();
                    OptimizedPlayerTextureBakery.setPlayerTexture(player, textureLocation);
                    OptimizedPlayerTextureBakery.INSTANCE.pendingTextures.remove(playerUUID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderPlayerEvent.Post event) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures;
        if (!(event.getEntityPlayer() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
        if (playerInfo != null && (playerTextures = OptimizedPlayerTextureBakery.getPlayerTextures(playerInfo)) != null) {
            ResourceLocation currentTexture = player.func_110306_p();
            TextureCache.CachedTexture cachedTexture = OptimizedPlayerTextureBakery.INSTANCE.textureCache.getCachedTexture(player.func_110124_au(), ((IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null)).computeHash());
            if (cachedTexture != null && currentTexture == cachedTexture.location) {
                playerTextures.put(MinecraftProfileTexture.Type.SKIN, OptimizedPlayerTextureBakery.INSTANCE.normalTexture);
            }
        }
    }

    public void requestPlayerSkinLoading(final AbstractClientPlayer player) {
        boolean isSlim = player.func_175154_l().equals("slim");
        TextureManager.getInstance().loadPlayerDefaultSkin(player.func_110124_au(), isSlim);
        Minecraft.func_71410_x().func_152342_ad().func_152790_a(player.func_146103_bH(), new SkinManager.SkinAvailableCallback(){

            public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                    TextureManager.getInstance().loadPlayerBaseSkin(player.func_110124_au(), profileTexture.getUrl());
                    OptimizedPlayerTextureBakery.this.generatePlayerTexture(player, null);
                }
            }
        }, false);
    }

    public void generatePlayerTexture(AbstractClientPlayer player, @Nullable BufferedImage armourerPixels) {
        UUID playerUUID = player.func_110124_au();
        CompletableFuture<ResourceLocation> pendingTexture = this.pendingTextures.get(playerUUID);
        if (pendingTexture != null && !pendingTexture.isDone()) {
            pendingTexture.cancel(true);
        }
        CompletableFuture<ResourceLocation> newTexture = this.textureGenerator.generateTexture(player, armourerPixels);
        this.pendingTextures.put(playerUUID, newTexture);
    }

    private boolean hasPlayerModificationsChanged(UUID playerUUID, IPlayerModifications modifications) {
        TextureCache.CachedTexture cachedTexture = this.textureCache.getCachedTexture(playerUUID, modifications.computeHash());
        return cachedTexture == null;
    }

    @Nullable
    private static Map<MinecraftProfileTexture.Type, ResourceLocation> getPlayerTextures(NetworkPlayerInfo playerInfo) {
        try {
            Class<?> playerInfoClass = playerInfo.getClass();
            Field field = ObfuscationReflectionHelper.findField(playerInfoClass, (String)"field_187107_a");
            field.setAccessible(true);
            return (Map)field.get(playerInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static ResourceLocation getOriginalSkinLocation(AbstractClientPlayer player) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures;
        NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
        if (playerInfo != null && (playerTextures = OptimizedPlayerTextureBakery.getPlayerTextures(playerInfo)) != null) {
            return playerTextures.get(MinecraftProfileTexture.Type.SKIN);
        }
        return null;
    }

    private static void setPlayerTexture(AbstractClientPlayer player, ResourceLocation textureLocation) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures;
        NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
        if (playerInfo != null && (playerTextures = OptimizedPlayerTextureBakery.getPlayerTextures(playerInfo)) != null) {
            playerTextures.put(MinecraftProfileTexture.Type.SKIN, textureLocation);
        }
    }

    public static boolean saveImageToFile(BufferedImage image, String filePath, String formatName) {
        File outputFile = new File(filePath);
        File parentDir = outputFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            return ImageIO.write((RenderedImage)image, formatName, outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

