/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.texture;

import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImageProcessor {
    private static final int MINECRAFT_SKIN_SIZE = 64;
    private static final Map<String, BufferedImage> SCALED_IMAGE_CACHE = new ConcurrentHashMap<String, BufferedImage>();
    private static final int MAX_CACHE_SIZE = 100;

    public static BufferedImage mergeImages(BufferedImage base, BufferedImage overlay) {
        try {
            int baseWidth = base.getWidth();
            int baseHeight = base.getHeight();
            int modWidth = overlay.getWidth();
            int modHeight = overlay.getHeight();
            BufferedImage standardRes = new BufferedImage(64, 64, 2);
            BufferedImage highRes = new BufferedImage(Math.max(baseWidth, modWidth), Math.max(baseHeight, modHeight), 2);
            BufferedImage scaledBase64 = ImageProcessor.scaleImage(base, 64, 64);
            BufferedImage scaledMod64 = ImageProcessor.scaleImage(overlay, 64, 64);
            for (int x = 0; x < 64; ++x) {
                for (int y = 0; y < 64; ++y) {
                    int basePixel = scaledBase64.getRGB(x, y);
                    int modPixel = scaledMod64.getRGB(x, y);
                    int modAlpha = modPixel >> 24 & 0xFF;
                    standardRes.setRGB(x, y, modAlpha != 0 ? modPixel : basePixel);
                }
            }
            BufferedImage scaledBaseHigh = ImageProcessor.scaleImage(base, highRes.getWidth(), highRes.getHeight());
            BufferedImage scaledModHigh = ImageProcessor.scaleImage(overlay, highRes.getWidth(), highRes.getHeight());
            for (int x = 0; x < highRes.getWidth(); ++x) {
                for (int y = 0; y < highRes.getHeight(); ++y) {
                    int basePixel = scaledBaseHigh.getRGB(x, y);
                    int modPixel = scaledModHigh.getRGB(x, y);
                    int modAlpha = modPixel >> 24 & 0xFF;
                    highRes.setRGB(x, y, modAlpha != 0 ? modPixel : basePixel);
                }
            }
            return highRes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage colorTexture(BufferedImage texture, float[] color) {
        try {
            int width = texture.getWidth();
            int height = texture.getHeight();
            BufferedImage result = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int pixel = texture.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    float luminance = ((float)red * 0.299f + (float)green * 0.587f + (float)blue * 0.114f) / 255.0f;
                    int newRed = Math.min(255, Math.round(luminance * (float)red * color[0]));
                    int newGreen = Math.min(255, Math.round(luminance * (float)green * color[1]));
                    int newBlue = Math.min(255, Math.round(luminance * (float)blue * color[2]));
                    int newPixel = alpha << 24 | newRed << 16 | newGreen << 8 | newBlue;
                    result.setRGB(x, y, newPixel);
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage computeTextureDelta(BufferedImage original, BufferedImage modified) {
        int width = original.getWidth();
        int height = original.getHeight();
        int[] originalPixels = original.getRGB(0, 0, width, height, null, 0, width);
        int[] modifiedPixels = modified.getRGB(0, 0, width, height, null, 0, width);
        int[] deltaPixels = new int[originalPixels.length];
        for (int i = 0; i < originalPixels.length; ++i) {
            deltaPixels[i] = originalPixels[i] != modifiedPixels[i] ? modifiedPixels[i] : 0;
        }
        BufferedImage deltaImage = new BufferedImage(width, height, 2);
        deltaImage.setRGB(0, 0, width, height, deltaPixels, 0, width);
        return deltaImage;
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        String cacheKey = image.hashCode() + "_" + width + "x" + height;
        BufferedImage cached = SCALED_IMAGE_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        BufferedImage scaled = new BufferedImage(width, height, 2);
        scaled.getGraphics().drawImage(image.getScaledInstance(width, height, 4), 0, 0, null);
        if (SCALED_IMAGE_CACHE.size() < 100) {
            SCALED_IMAGE_CACHE.put(cacheKey, scaled);
        }
        return scaled;
    }

    public static int computeImageHash(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int SAMPLE_STEP = 4;
        int hash = width * 31 + height;
        for (int y = 0; y < height; y += 4) {
            for (int x = 0; x < width; x += 4) {
                hash = 31 * hash + image.getRGB(x, y);
            }
        }
        return hash;
    }

    public static float[] intToRgb(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }

    public static float[] hexToRgb(String hexColor) {
        int hex = Integer.decode(hexColor);
        int red = (hex & 0xFF0000) >> 16;
        int green = (hex & 0xFF00) >> 8;
        int blue = hex & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }
}

