/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.texture;

import fr.minepiece.client.model.modifications.SkinModifications;
import fr.minepiece.client.render.Skins;
import fr.minepiece.client.render.texture.ImageProcessor;
import fr.minepiece.client.render.texture.TextureCache;
import fr.minepiece.client.render.texture.TextureManager;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class AsyncTextureGenerator {
    private static final AsyncTextureGenerator INSTANCE = new AsyncTextureGenerator();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    private AsyncTextureGenerator() {
    }

    public static AsyncTextureGenerator getInstance() {
        return INSTANCE;
    }

    public CompletableFuture<ResourceLocation> generateTexture(AbstractClientPlayer player, @Nullable BufferedImage armourerPixels) {
        IPlayerModifications playerModifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (playerModifications == null) {
                    return player.func_110306_p();
                }
                BufferedImage baseSkin = TextureManager.getInstance().getPlayerBaseSkin(player.func_110124_au());
                if (baseSkin == null) {
                    return player.func_110306_p();
                }
                BufferedImage customSkin = TextureManager.getInstance().getSkinTexture(Objects.requireNonNull(Skins.getSkinFromName(playerModifications.getSkin())).getLocation());
                customSkin = ImageProcessor.colorTexture(customSkin, ImageProcessor.intToRgb(playerModifications.getSkinColor()));
                BufferedImage mergedSkin = ImageProcessor.mergeImages(baseSkin, customSkin);
                mergedSkin = this.addSkinModifications(mergedSkin, playerModifications);
                if (armourerPixels != null) {
                    mergedSkin = ImageProcessor.mergeImages(mergedSkin, armourerPixels);
                }
                UUID playerUUID = player.func_110124_au();
                ResourceLocation textureLocation = new ResourceLocation("minepiece", "textures/players/custom_" + playerUUID.toString().replace("-", ""));
                CompletableFuture uploadFuture = new CompletableFuture();
                BufferedImage finalMergedSkin = mergedSkin;
                Minecraft.func_71410_x().func_152344_a(() -> {
                    try {
                        DynamicTexture texture = new DynamicTexture(finalMergedSkin);
                        Minecraft.func_71410_x().func_110434_K().func_110579_a(textureLocation, (ITextureObject)texture);
                        try {
                            CustomResourcePack customPack;
                            List resourcePacks;
                            SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110451_am");
                            Map domainResourceManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)resourceManager, (String)"field_110548_a");
                            FallbackResourceManager modManager = (FallbackResourceManager)domainResourceManagers.get("minepiece");
                            if (modManager != null && !(resourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(FallbackResourceManager.class, (Object)modManager, (String)"field_110540_a")).contains(customPack = new CustomResourcePack(textureLocation, finalMergedSkin))) {
                                resourcePacks.add(customPack);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int modificationHash = playerModifications.computeHash();
                        TextureCache.getInstance().cacheTexture(playerUUID, textureLocation, modificationHash, finalMergedSkin);
                        uploadFuture.complete(textureLocation);
                    }
                    catch (Exception e) {
                        uploadFuture.completeExceptionally(e);
                    }
                });
                return (ResourceLocation)uploadFuture.join();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                return player.func_110306_p();
            }
        }, this.executor);
    }

    private BufferedImage addSkinModifications(BufferedImage skin, IPlayerModifications modifications) {
        for (String modification : modifications.getSkinModifications()) {
            BufferedImage skinModificationImage;
            ResourceLocation skinModification = SkinModifications.getResourceByName(modification);
            if (skinModification == null || (skinModificationImage = TextureManager.getInstance().getSkinTexture(skinModification)) == null) continue;
            skinModificationImage = modification.equals("fishman_gills") ? ImageProcessor.colorTexture(skinModificationImage, ImageProcessor.hexToRgb("0xFFFFFF")) : ImageProcessor.colorTexture(skinModificationImage, ImageProcessor.intToRgb(modifications.getModificationColor()));
            skin = ImageProcessor.mergeImages(skin, skinModificationImage);
        }
        return skin;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    private class CustomResourcePack
    implements IResourcePack {
        private final ResourceLocation textureLocation;
        private final byte[] textureData;

        public CustomResourcePack(ResourceLocation location, BufferedImage image) {
            this.textureLocation = location;
            this.textureData = this.imageToByteArray(image);
        }

        private byte[] imageToByteArray(BufferedImage image) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "PNG", baos);
                return baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                return new byte[0];
            }
        }

        public InputStream func_110590_a(ResourceLocation location) throws IOException {
            if (location.equals((Object)this.textureLocation)) {
                return new ByteArrayInputStream(this.textureData);
            }
            throw new FileNotFoundException(location.toString());
        }

        public boolean func_110589_b(ResourceLocation location) {
            return location.equals((Object)this.textureLocation);
        }

        public Set<String> func_110587_b() {
            return Collections.singleton("minepiece");
        }

        public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
            return null;
        }

        public BufferedImage func_110586_a() throws IOException {
            return null;
        }

        public String func_130077_b() {
            return "minepiece_dynamic_textures";
        }
    }
}

