/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.sphere;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class SphereVBO {
    private int vboId;
    private int vertexCount;
    private static final int STEPS = 16;
    private static final double[] COS_THETA = new double[17];
    private static final double[] SIN_THETA = new double[17];
    private static final double[] COS_PHI = new double[17];
    private static final double[] SIN_PHI = new double[17];

    public SphereVBO(float r, float g, float b, float a) {
        this.createSphereVBO(r, g, b, a);
    }

    private void createSphereVBO(float r, float g, float b, float a) {
        float radius = 1.0f;
        int quads = 256;
        this.vertexCount = quads * 4;
        int floatsPerVertex = 7;
        float[] vertexData = new float[this.vertexCount * floatsPerVertex];
        int index = 0;
        for (int i = 0; i < 16; ++i) {
            double sinPhi0 = SIN_PHI[i];
            double cosPhi0 = COS_PHI[i];
            double sinPhi1 = SIN_PHI[i + 1];
            double cosPhi1 = COS_PHI[i + 1];
            for (int j = 0; j < 16; ++j) {
                double cosTheta0 = COS_THETA[j];
                double sinTheta0 = SIN_THETA[j];
                double cosTheta1 = COS_THETA[j + 1];
                double sinTheta1 = SIN_THETA[j + 1];
                vertexData[index++] = (float)(1.0 * cosTheta0 * cosPhi0);
                vertexData[index++] = (float)(1.0 * sinPhi0);
                vertexData[index++] = (float)(1.0 * sinTheta0 * cosPhi0);
                vertexData[index++] = r;
                vertexData[index++] = g;
                vertexData[index++] = b;
                vertexData[index++] = a;
                vertexData[index++] = (float)(1.0 * cosTheta1 * cosPhi0);
                vertexData[index++] = (float)(1.0 * sinPhi0);
                vertexData[index++] = (float)(1.0 * sinTheta1 * cosPhi0);
                vertexData[index++] = r;
                vertexData[index++] = g;
                vertexData[index++] = b;
                vertexData[index++] = a;
                vertexData[index++] = (float)(1.0 * cosTheta1 * cosPhi1);
                vertexData[index++] = (float)(1.0 * sinPhi1);
                vertexData[index++] = (float)(1.0 * sinTheta1 * cosPhi1);
                vertexData[index++] = r;
                vertexData[index++] = g;
                vertexData[index++] = b;
                vertexData[index++] = a;
                vertexData[index++] = (float)(1.0 * cosTheta0 * cosPhi1);
                vertexData[index++] = (float)(1.0 * sinPhi1);
                vertexData[index++] = (float)(1.0 * sinTheta0 * cosPhi1);
                vertexData[index++] = r;
                vertexData[index++] = g;
                vertexData[index++] = b;
                vertexData[index++] = a;
            }
        }
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)vertexData.length);
        buffer.put(vertexData).flip();
        this.vboId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vboId);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void render(float desiredRadius) {
        GL11.glScalef((float)desiredRadius, (float)desiredRadius, (float)desiredRadius);
        int stride = 28;
        long colorOffset = 12L;
        GL15.glBindBuffer((int)34962, (int)this.vboId);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)3, (int)5126, (int)stride, (long)0L);
        GL11.glColorPointer((int)4, (int)5126, (int)stride, (long)colorOffset);
        GL11.glDrawArrays((int)7, (int)0, (int)this.vertexCount);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32884);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void delete() {
        GL15.glDeleteBuffers((int)this.vboId);
    }

    static {
        try {
            for (int i = 0; i <= 16; ++i) {
                double theta = Math.PI * 2 * (double)i / 16.0;
                SphereVBO.COS_THETA[i] = Math.cos(theta);
                SphereVBO.SIN_THETA[i] = Math.sin(theta);
                double phi = Math.PI * ((double)i / 16.0 - 0.5);
                SphereVBO.COS_PHI[i] = Math.cos(phi);
                SphereVBO.SIN_PHI[i] = Math.sin(phi);
            }
        }
        catch (Throwable e) {
            System.err.println("Error initializing sphere VBO static data");
            e.printStackTrace();
        }
    }
}

