/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.sphere;

import fr.minepiece.client.render.sphere.SphereCallback;
import fr.minepiece.client.render.sphere.SphereVBO;
import net.minecraft.util.math.Vec3d;

public class SphereRenderObject {
    private float radius;
    private Vec3d center;
    private float[] color;
    private SphereVBO vbo;
    private SphereCallback callback;
    private int shader = -1;
    private long ticksLeft;

    public SphereRenderObject(float radius, Vec3d center, float[] color, SphereCallback callback, int ticksLeft, int shader) {
        this(radius, center, color, callback, ticksLeft);
        this.shader = shader;
    }

    public SphereRenderObject(float radius, Vec3d center, float[] color, SphereCallback callback, int ticksLeft) {
        this.radius = radius;
        this.center = center;
        this.color = color;
        this.callback = callback;
        this.ticksLeft = ticksLeft;
    }

    public long getTicksLeft() {
        return this.ticksLeft;
    }

    public void removeLifetime(long timeToRemove) {
        this.ticksLeft -= timeToRemove;
    }

    public int getShader() {
        return this.shader;
    }

    public SphereCallback getCallback() {
        return this.callback;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public Vec3d getCenter() {
        return this.center;
    }

    public void setCenter(Vec3d center) {
        this.center = center;
    }

    public float[] getColor() {
        return this.color;
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public SphereVBO getVbo() {
        return this.vbo;
    }

    public void createVbo() {
        this.vbo = new SphereVBO(this.color[0], this.color[1], this.color[2], this.color[3]);
    }
}

