/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.sphere;

import fr.minepiece.client.render.ShaderCallback;
import fr.minepiece.client.render.ShaderHelper;
import fr.minepiece.client.render.sphere.SphereRenderObject;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;

public class SphereManager {
    private static HashMap<Long, SphereRenderObject> sphereVBO = new HashMap();
    private static long id = 0L;
    public static final ShaderCallback callback = shader -> {
        int disfigurationUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"disfiguration");
        ARBShaderObjects.glUniform1fARB((int)disfigurationUniform, (float)0.4f);
        int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"grainIntensity");
        ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)1.0f);
    };

    @SideOnly(value=Side.CLIENT)
    private static void renderSphere(SphereRenderObject sphereRenderObject) {
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Vec3d view = new Vec3d(manager.field_78730_l, manager.field_78731_m, manager.field_78728_n);
        Vec3d center = sphereRenderObject.getCenter();
        float radius = sphereRenderObject.getRadius();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179137_b((double)(-view.field_72450_a + center.field_72450_a), (double)(-view.field_72448_b + center.field_72448_b), (double)(-view.field_72449_c + center.field_72449_c));
        sphereRenderObject.getVbo().render(radius);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static long addFullSphere(SphereRenderObject sphereRenderObject) {
        sphereRenderObject.createVbo();
        return SphereManager.addSphere(sphereRenderObject);
    }

    public static long addSphere(SphereRenderObject sphereRenderObject) {
        long currentId = id++;
        sphereVBO.put(currentId, sphereRenderObject);
        return currentId;
    }

    public static void removeSphere(Long id) {
        sphereVBO.get(id).getVbo().delete();
        sphereVBO.remove(id);
    }

    public static void updateSphereRadius(Long id, float radius) {
        sphereVBO.get(id).setRadius(radius);
    }

    public static SphereRenderObject getSphereRenderObject(Long id) {
        return sphereVBO.get(id);
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class ClientEventHandler {
        @SubscribeEvent
        public static void onWorldRenderLast(RenderWorldLastEvent event) {
            Entity viewer = Minecraft.func_71410_x().func_175606_aa();
            for (Long id : sphereVBO.keySet()) {
                SphereRenderObject sphereRenderObject = (SphereRenderObject)sphereVBO.get(id);
                Vec3d center = sphereRenderObject.getCenter();
                if (viewer.func_70092_e(center.field_72450_a, center.field_72448_b, center.field_72449_c) > 1024.0) continue;
                if (sphereRenderObject.getShader() != -1) {
                    ShaderHelper.useShader(sphereRenderObject.getShader(), callback);
                    SphereManager.renderSphere(sphereRenderObject);
                    ShaderHelper.release();
                    continue;
                }
                SphereManager.renderSphere(sphereRenderObject);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onTick(TickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ArrayList<Long> spheresToRemove = new ArrayList<Long>();
            for (Long id : sphereVBO.keySet()) {
                SphereRenderObject object = SphereManager.getSphereRenderObject(id);
                object.removeLifetime(1L);
                object.getCallback().callback(object, event.side);
                if (object.getTicksLeft() >= 0L) continue;
                spheresToRemove.add(id);
            }
            if (event.side.isServer()) {
                for (Long id : spheresToRemove) {
                    sphereVBO.remove(id);
                }
            } else {
                spheresToRemove.forEach(SphereManager::removeSphere);
            }
        }
    }
}

