/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.shaders;

import fr.minepiece.client.render.shaders.SmokeCloudClientData;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="minepiece", value={Side.CLIENT})
public class SmokeFogRenderer {
    private static final int MAX_SHADER_CLOUDS = 16;
    private static final ResourceLocation SMOKE_TEXTURE = new ResourceLocation("minepiece", "textures/gui/effects/smoke_texture.png");

    @SubscribeEvent
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        Vec3d cameraPos = viewEntity.func_174824_e(mc.func_184121_ak());
        List<SmokeCloudClientData> activeEffects = SmokeFogRenderer.collectCloudsToRender(mc, cameraPos);
        Vec3d eyePos = viewEntity.func_174824_e((float)event.getRenderPartialTicks());
        float[] color = SmokeCloudClientData.getSmokeColorAt(eyePos);
        if (color != null) {
            event.setCanceled(true);
            float closestDistance = Float.MAX_VALUE;
            float alpha = 0.0f;
            for (SmokeCloudClientData effect : activeEffects) {
                double distance = eyePos.func_72438_d(new Vec3d(effect.position.field_72450_a, effect.position.field_72448_b, effect.position.field_72449_c));
                float depthFactor = 1.0f - (float)Math.min(1.0, distance / (double)effect.radius);
                float effectAlpha = effect.density * depthFactor;
                if (!(effectAlpha > alpha)) continue;
                alpha = effectAlpha;
                color = effect.getSmokeColor();
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(0.1f + alpha * 0.6f);
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)(0.1f + alpha * 0.6f));
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)10.0f);
            GL11.glFog((int)2918, (FloatBuffer)SmokeFogRenderer.createFloatBuffer(color[0], color[1], color[2], 1.0f));
            GL11.glEnable((int)2912);
        }
    }

    private static FloatBuffer createFloatBuffer(float r, float g, float b, float a) {
        FloatBuffer buffer = ByteBuffer.allocateDirect(16).asFloatBuffer();
        buffer.put(r).put(g).put(b).put(a);
        buffer.flip();
        return buffer;
    }

    private static List<SmokeCloudClientData> collectCloudsToRender(Minecraft mc, Vec3d cameraPos) {
        ArrayList<SmokeCloudClientData> cloudsToRender = new ArrayList<SmokeCloudClientData>();
        double maxRenderDistSq = Math.pow((double)mc.field_71474_y.field_151451_c * 16.0 + 64.0, 2.0);
        for (SmokeCloudClientData cloud : SmokeCloudClientData.activeClouds.values()) {
            if (!(cloud.position.func_72436_e(cameraPos) <= maxRenderDistSq)) continue;
            cloudsToRender.add(cloud);
        }
        return cloudsToRender;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewer = mc.func_175606_aa();
        float partialTicks = event.getPartialTicks();
        Vec3d viewerPos = viewer.func_174824_e(partialTicks).func_178786_a(0.0, (double)viewer.func_70047_e(), 0.0);
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SMOKE_TEXTURE);
        List<SmokeCloudClientData> activeEffects = SmokeFogRenderer.collectCloudsToRender(mc, viewerPos);
        for (SmokeCloudClientData effect : activeEffects) {
            Vec3d smokePos = effect.position;
            float radius = effect.radius;
            double distanceToSmoke = viewerPos.func_72438_d(smokePos);
            if (distanceToSmoke < (double)radius || distanceToSmoke > 128.0) continue;
            float alpha = effect.density * 1.2f;
            float[] color = effect.getSmokeColor();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            Vec3d direction = smokePos.func_178788_d(viewerPos).func_72432_b();
            Vec3d up = Math.abs(direction.field_72448_b) > 0.99 ? new Vec3d(1.0, 0.0, 0.0) : new Vec3d(0.0, 1.0, 0.0);
            Vec3d right = direction.func_72431_c(up).func_72432_b();
            up = right.func_72431_c(direction).func_72432_b();
            int layers = 6;
            float layerSpacing = radius * 1.75f / (float)layers;
            for (int layer = 0; layer < layers; ++layer) {
                float layerDist = (float)layer * layerSpacing;
                Vec3d layerPos = smokePos.func_178788_d(direction.func_186678_a((double)radius * 0.75 - (double)layerDist));
                float layerScale = radius * 1.5f;
                float layerAlpha = alpha * (1.0f - (float)Math.abs(layer - layers / 2) / (float)(layers / 2)) * 0.7f;
                float time = (float)((double)(Minecraft.func_71386_F() % 10000L) / 10000.0);
                float offsetX = MathHelper.func_76126_a((float)(time * 2.0f * (float)Math.PI + (float)layer * 0.7f)) * 0.1f;
                float offsetY = MathHelper.func_76134_b((float)(time * 2.0f * (float)Math.PI + (float)layer * 0.9f)) * 0.1f;
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                double translateX = layerPos.field_72450_a - viewer.field_70165_t;
                double translateY = layerPos.field_72448_b - viewer.field_70163_u;
                double translateZ = layerPos.field_72449_c - viewer.field_70161_v;
                bufferBuilder.func_181662_b(translateX + (-right.field_72450_a - up.field_72450_a) * (double)layerScale + (double)offsetX, translateY + (-right.field_72448_b - up.field_72448_b) * (double)layerScale + (double)offsetY, translateZ + (-right.field_72449_c - up.field_72449_c) * (double)layerScale).func_187315_a(0.0, 0.0).func_181666_a(color[0], color[1], color[2], layerAlpha).func_181675_d();
                bufferBuilder.func_181662_b(translateX + (right.field_72450_a - up.field_72450_a) * (double)layerScale + (double)offsetX, translateY + (right.field_72448_b - up.field_72448_b) * (double)layerScale + (double)offsetY, translateZ + (right.field_72449_c - up.field_72449_c) * (double)layerScale).func_187315_a(1.0, 0.0).func_181666_a(color[0], color[1], color[2], layerAlpha).func_181675_d();
                bufferBuilder.func_181662_b(translateX + (right.field_72450_a + up.field_72450_a) * (double)layerScale + (double)offsetX, translateY + (right.field_72448_b + up.field_72448_b) * (double)layerScale + (double)offsetY, translateZ + (right.field_72449_c + up.field_72449_c) * (double)layerScale).func_187315_a(1.0, 1.0).func_181666_a(color[0], color[1], color[2], layerAlpha).func_181675_d();
                bufferBuilder.func_181662_b(translateX + (-right.field_72450_a + up.field_72450_a) * (double)layerScale + (double)offsetX, translateY + (-right.field_72448_b + up.field_72448_b) * (double)layerScale + (double)offsetY, translateZ + (-right.field_72449_c + up.field_72449_c) * (double)layerScale).func_187315_a(0.0, 1.0).func_181666_a(color[0], color[1], color[2], layerAlpha).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            SmokeCloudClientData.cleanupExpired(Minecraft.func_71410_x().field_71441_e.func_82737_E());
        }
    }
}

