/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.shaders;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.Vec3d;

public class SmokeCloudClientData {
    public static final Map<String, SmokeCloudClientData> activeClouds = new HashMap<String, SmokeCloudClientData>();
    public final Vec3d position;
    public final float radius;
    public final float radiusSq;
    public final float r;
    public final float g;
    public final float b;
    public final float density;
    public final long expiryTime;

    public SmokeCloudClientData(Vec3d position, float radius, float r, float g, float b, float density, long expiryTime) {
        this.position = position;
        this.radius = radius;
        this.radiusSq = radius * radius;
        this.r = r;
        this.g = g;
        this.b = b;
        this.density = Math.max(0.0f, Math.min(1.0f, density));
        this.expiryTime = expiryTime;
    }

    public static void cleanupExpired(long currentTime) {
        Iterator<Map.Entry<String, SmokeCloudClientData>> it = activeClouds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SmokeCloudClientData> entry = it.next();
            if (entry.getValue().expiryTime > currentTime) continue;
            it.remove();
        }
    }

    public static float[] getSmokeColorAt(Vec3d position) {
        for (SmokeCloudClientData effect : activeClouds.values()) {
            double distance = position.func_72438_d(new Vec3d(effect.position.field_72450_a, effect.position.field_72448_b, effect.position.field_72449_c));
            if (!(distance <= (double)effect.radius)) continue;
            return effect.getSmokeColor();
        }
        return null;
    }

    public int getColor() {
        return new Color(this.r, this.g, this.b).getRGB();
    }

    public float[] getSmokeColor() {
        return new float[]{this.r, this.g, this.b};
    }
}

