/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render.layers;

import fr.minepiece.client.model.CustomArmorModelBiped;
import fr.minepiece.client.model.modifications.AbstractPlayerModification;
import fr.minepiece.client.model.registry.ModelRegistry;
import fr.minepiece.client.model.visibility.ModelVisibilityManager;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class OptimizedLayerCustomBipedArmor
extends LayerArmorBase<ModelBiped> {
    private final RenderLivingBase<?> renderer;

    public OptimizedLayerCustomBipedArmor(RenderLivingBase<?> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    protected void func_177177_a() {
        this.field_177189_c = new CustomArmorModelBiped(0.5f);
        this.field_177186_d = new CustomArmorModelBiped(1.0f);
    }

    protected void setModelSlotVisible(ModelBiped p_188359_1_, EntityEquipmentSlot slotIn) {
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemArmor itemarmor;
        ItemStack itemstack;
        IPlayerModifications modifications = (IPlayerModifications)entityLivingBaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (modifications == null) {
            return;
        }
        ModelVisibilityManager.resetVisibility((ModelBiped)this.field_177189_c);
        ModelVisibilityManager.resetVisibility((ModelBiped)this.field_177186_d);
        if (!modifications.getModifications().isEmpty()) {
            ArrayList<AbstractPlayerModification> playerModifications = new ArrayList<AbstractPlayerModification>();
            for (String modificationName : modifications.getModifications()) {
                AbstractPlayerModification modification = ModelRegistry.getModification(modificationName);
                if (modification == null) continue;
                playerModifications.add(modification);
            }
            for (AbstractPlayerModification modification : playerModifications) {
                modification.setModelVisibilities((ModelBiped)this.field_177189_c);
                modification.setModelVisibilities((ModelBiped)this.field_177186_d);
            }
        }
        if ((itemstack = entityLivingBaseIn.func_184582_a(slotIn)).func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            CustomArmorModelBiped modelBiped = this.getModelFromSlot(slotIn);
            modelBiped = this.getArmorModelHook(entityLivingBaseIn, itemstack, slotIn, modelBiped);
            modelBiped.func_178686_a(this.renderer.func_177087_b());
            modelBiped.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.setModelSlotVisible(modelBiped, slotIn);
            this.renderer.func_110776_a(this.getArmorResource((Entity)entityLivingBaseIn, itemstack, slotIn, null));
            float[] colors = OptimizedLayerCustomBipedArmor.getLayerArmorBaseColors(this);
            float colorR = colors[0];
            float colorG = colors[1];
            float colorB = colors[2];
            float alpha = colors[3];
            if (itemarmor.hasOverlay(itemstack)) {
                int i = itemarmor.func_82814_b(itemstack);
                float redConstant = (float)(i >> 16 & 0xFF) / 255.0f;
                float greenConstant = (float)(i >> 8 & 0xFF) / 255.0f;
                float blueConstant = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(colorR * redConstant), (float)(colorG * greenConstant), (float)(colorB * blueConstant), (float)alpha);
                modelBiped.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.renderer.func_110776_a(this.getArmorResource((Entity)entityLivingBaseIn, itemstack, slotIn, "overlay"));
            }
            GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)alpha);
            modelBiped.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (!OptimizedLayerCustomBipedArmor.getLayerArmorBaseSkipRenderGlint(this) && itemstack.func_77962_s()) {
                OptimizedLayerCustomBipedArmor.func_188364_a(this.renderer, (EntityLivingBase)entityLivingBaseIn, (ModelBase)modelBiped, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            }
        }
    }

    public CustomArmorModelBiped getModelFromSlot(EntityEquipmentSlot slotIn) {
        return (CustomArmorModelBiped)(this.isLegSlot(slotIn) ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d);
    }

    protected CustomArmorModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return (CustomArmorModelBiped)ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slot, (ModelBiped)model);
    }

    private static float[] getLayerArmorBaseColors(LayerArmorBase<?> layer) {
        try {
            Field colorR = LayerArmorBase.class.getDeclaredField("colorR");
            Field colorG = LayerArmorBase.class.getDeclaredField("colorG");
            Field colorB = LayerArmorBase.class.getDeclaredField("colorB");
            Field alpha = LayerArmorBase.class.getDeclaredField("alpha");
            colorR.setAccessible(true);
            colorG.setAccessible(true);
            colorB.setAccessible(true);
            alpha.setAccessible(true);
            return new float[]{colorR.getFloat(layer), colorG.getFloat(layer), colorB.getFloat(layer), alpha.getFloat(layer)};
        }
        catch (Exception e) {
            return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
    }

    private static boolean getLayerArmorBaseSkipRenderGlint(LayerArmorBase<?> layer) {
        try {
            Field skipRenderGlint = LayerArmorBase.class.getDeclaredField("skipRenderGlint");
            skipRenderGlint.setAccessible(true);
            return skipRenderGlint.getBoolean(layer);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }
}

