/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render;

import fr.minepiece.MinePiece;
import fr.minepiece.client.render.ShaderCallback;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int smokeFogShader = 0;
    private static boolean lighting;

    private static void deleteShader(int id) {
        if (id != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)id);
        }
    }

    public static void initShaders() {
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> {
                ShaderHelper.deleteShader(smokeFogShader);
                smokeFogShader = 0;
                ShaderHelper.loadShaders();
            });
        }
    }

    private static void loadShaders() {
        smokeFogShader = ShaderHelper.createProgram(new ResourceLocation("minepiece", "shaders/smoke_fog.vert"), new ResourceLocation("minepiece", "shaders/smoke_fog.frag"));
        MinePiece.LOGGER.info("Loading Smoke Fog Shader");
    }

    private int loadShader(ResourceLocation location, int type) throws Exception {
        InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
        String source = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        IOUtils.closeQuietly((InputStream)inputStream);
        int shaderId = GL20.glCreateShader((int)type);
        if (shaderId == 0) {
            throw new RuntimeException("Could not create shader of type " + type + " for " + location);
        }
        GL20.glShaderSource((int)shaderId, (CharSequence)source);
        GL20.glCompileShader((int)shaderId);
        if (GL20.glGetShaderi((int)shaderId, (int)35713) == 0) {
            String log = GL20.glGetShaderInfoLog((int)shaderId, (int)512);
            GL20.glDeleteShader((int)shaderId);
            throw new RuntimeException("Failed to compile shader " + location + ": " + log);
        }
        return shaderId;
    }

    private static int createProgram(ResourceLocation vert, ResourceLocation frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            MinePiece.LOGGER.error(ShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            MinePiece.LOGGER.error(ShaderHelper.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(ResourceLocation location, int shaderType) {
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            String source = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            IOUtils.closeQuietly((InputStream)inputStream);
            int shaderId = GL20.glCreateShader((int)shaderType);
            if (shaderId == 0) {
                throw new RuntimeException("Could not create shader of type " + shaderType + " for " + location);
            }
            GL20.glShaderSource((int)shaderId, (CharSequence)source);
            GL20.glCompileShader((int)shaderId);
            if (GL20.glGetShaderi((int)shaderId, (int)35713) == 0) {
                String log = GL20.glGetShaderInfoLog((int)shaderId, (int)512);
                GL20.glDeleteShader((int)shaderId);
                throw new RuntimeException("Failed to compile shader " + location + ": " + log);
            }
            return shaderId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static void use(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void useShader(int shader, ShaderCallback callback) {
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179140_f();
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)((int)(Minecraft.func_71386_F() / 1000L % 1000000L)));
            if (callback != null) {
                callback.call(shader);
            }
        }
    }

    public static void release() {
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        ShaderHelper.use(0);
    }
}

