/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render;

import fr.minepiece.client.model.CustomPlayerModel;
import fr.minepiece.client.model.layers.LayerCustomBipedArmor;
import fr.minepiece.client.model.modifications.AbstractPlayerModification;
import fr.minepiece.client.model.modifications.PlayerModifications;
import fr.minepiece.client.model.modifications.SkinModifications;
import fr.minepiece.client.render.Skins;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.mixinaccessors.IMixinEntityPlayerLaidDown;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCustomPlayer
extends RenderPlayer {
    private final CustomPlayerModel customModel = new CustomPlayerModel();

    public RenderCustomPlayer(RenderManager renderManager) {
        this(renderManager, false);
    }

    public RenderCustomPlayer(RenderManager renderManager, boolean useSmallArms) {
        super(renderManager, useSmallArms);
        this.field_77045_g = this.customModel;
        this.removeArmorLayer();
        this.func_177094_a((LayerRenderer)new LayerCustomBipedArmor((RenderLivingBase<?>)this));
    }

    private void removeArmorLayer() {
        Iterator iterator = this.field_177097_h.iterator();
        while (iterator.hasNext()) {
            LayerRenderer layerRenderer = (LayerRenderer)iterator.next();
            if (!(layerRenderer instanceof LayerArmorBase)) continue;
            iterator.remove();
            break;
        }
    }

    public ModelPlayer func_177087_b() {
        return super.func_177087_b();
    }

    public void func_76986_a(AbstractClientPlayer entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entity.func_175144_cb() || this.field_76990_c.field_78734_h == entity) {
            this.setModelVisibilities(entity);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    protected void renderModel(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        IPlayerModifications modifications = (IPlayerModifications)entitylivingbaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (modifications != null);
        ModelPlayer model = this.func_177087_b();
        this.resetModelVisibilities(model);
        if (!modifications.getModifications().isEmpty()) {
            for (String modification : modifications.getModifications()) {
                AbstractPlayerModification playerModification = PlayerModifications.getModificationByName(modification);
                assert (playerModification != null);
                playerModification.setModelVisibilities(model);
                playerModification.setModelOffset(entitylivingbaseIn, model);
            }
        }
        this.originalRenderModel(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, true);
    }

    private void renderCustomSkin(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        IPlayerModifications playerModifications = (IPlayerModifications)entitylivingbaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (playerModifications != null);
        this.func_110776_a(Objects.requireNonNull(Skins.getSkinFromName(playerModifications.getSkin())).getLocation());
        float[] color = this.intToRgb(playerModifications.getSkinColor());
        GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
        this.originalRenderModel(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, false);
    }

    private void renderSkinModifications(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        IPlayerModifications playerModifications = (IPlayerModifications)entitylivingbaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (playerModifications != null);
        for (String modification : playerModifications.getSkinModifications()) {
            float[] color;
            ResourceLocation skinModification = SkinModifications.getResourceByName(modification);
            this.func_110776_a(skinModification);
            if (modification.equals("fishman_gills")) {
                color = this.hexToRgb("0xFFFFFF");
                GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
            } else {
                color = this.intToRgb(playerModifications.getModificationColor());
                GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
            }
            this.originalRenderModel(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, false);
        }
    }

    private void originalRenderModelHeadOnly(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, boolean bindSkin) {
        boolean isInvisibleToPlayer;
        boolean isEntityVisible = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = isInvisibleToPlayer = !isEntityVisible && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isEntityVisible || isInvisibleToPlayer) {
            if (bindSkin && !this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (isInvisibleToPlayer) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            ((CustomPlayerModel)this.field_77045_g).renderHeadOnly((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (isInvisibleToPlayer) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    private void originalRenderModel(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, boolean bindSkin) {
        boolean isInvisibleToPlayer;
        boolean isEntityVisible = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = isInvisibleToPlayer = !isEntityVisible && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isEntityVisible || isInvisibleToPlayer) {
            if (bindSkin && !this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (isInvisibleToPlayer) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (isInvisibleToPlayer) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected float[] hexToRgb(String hexColor) {
        int hex = Integer.decode(hexColor);
        int red = (hex & 0xFF0000) >> 16;
        int green = (hex & 0xFF00) >> 8;
        int blue = hex & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }

    private void resetModelVisibilities(ModelPlayer modelPlayer) {
        modelPlayer.field_178722_k.field_78807_k = false;
        modelPlayer.field_178733_c.field_78807_k = true;
        modelPlayer.field_178721_j.field_78807_k = false;
        modelPlayer.field_178731_d.field_78807_k = true;
        modelPlayer.field_178724_i.field_78807_k = false;
        modelPlayer.field_178734_a.field_78807_k = true;
        modelPlayer.field_178723_h.field_78807_k = false;
        modelPlayer.field_178732_b.field_78807_k = true;
        modelPlayer.field_78115_e.field_78807_k = false;
        modelPlayer.field_178730_v.field_78807_k = true;
        modelPlayer.field_78116_c.field_78807_k = false;
        modelPlayer.field_178720_f.field_78807_k = false;
    }

    private void setModelVisibilities(AbstractClientPlayer clientPlayer) {
        ModelPlayer modelplayer = this.func_177087_b();
        if (clientPlayer.func_175149_v()) {
            modelplayer.func_178719_a(false);
            modelplayer.field_78116_c.field_78806_j = true;
            modelplayer.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            modelplayer.func_178719_a(true);
            modelplayer.field_178720_f.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.HAT);
            modelplayer.field_178730_v.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.JACKET);
            modelplayer.field_178733_c.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
            modelplayer.field_178731_d.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
            modelplayer.field_178734_a.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
            modelplayer.field_178732_b.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
            modelplayer.field_78117_n = clientPlayer.func_70093_af();
            ModelBiped.ArmPose modelbiped$armpose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose modelbiped$armpose1 = ModelBiped.ArmPose.EMPTY;
            if (!itemstack.func_190926_b()) {
                modelbiped$armpose = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstack.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        modelbiped$armpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        modelbiped$armpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstack1.func_190926_b()) {
                modelbiped$armpose1 = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction1 = itemstack1.func_77975_n();
                    if (enumaction1 == EnumAction.BLOCK) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (clientPlayer.func_184591_cq() == EnumHandSide.RIGHT) {
                modelplayer.field_187076_m = modelbiped$armpose;
                modelplayer.field_187075_l = modelbiped$armpose1;
            } else {
                modelplayer.field_187076_m = modelbiped$armpose1;
                modelplayer.field_187075_l = modelbiped$armpose;
            }
        }
    }

    public ResourceLocation func_110775_a(AbstractClientPlayer entity) {
        return entity.func_110306_p();
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected void func_77041_b(AbstractClientPlayer entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    protected void func_188296_a(AbstractClientPlayer entityIn, double x, double y, double z, String name, double distanceSq) {
        Scoreboard scoreboard;
        ScoreObjective scoreobjective;
        if (distanceSq < 100.0 && (scoreobjective = (scoreboard = entityIn.func_96123_co()).func_96539_a(2)) != null) {
            Score score = scoreboard.func_96529_a(entityIn.func_70005_c_(), scoreobjective);
            this.func_147906_a((Entity)entityIn, score.func_96652_c() + " " + scoreobjective.func_96678_d(), x, y, z, 64);
            y += (double)((float)this.func_76983_a().field_78288_b * 1.15f * 0.025f);
        }
        super.func_188296_a(entityIn, x, y, z, name, distanceSq);
    }

    public void func_177138_b(AbstractClientPlayer clientPlayer) {
        float f = 1.0f;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.func_177087_b();
        this.setModelVisibilities(clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_78095_p = 0.0f;
        modelplayer.field_78117_n = false;
        modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        modelplayer.field_178723_h.field_78795_f = 0.0f;
        modelplayer.field_178723_h.func_78785_a(0.0625f);
        modelplayer.field_178732_b.field_78795_f = 0.0f;
        modelplayer.field_178732_b.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
    }

    public void func_177139_c(AbstractClientPlayer clientPlayer) {
        float f = 1.0f;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.func_177087_b();
        this.setModelVisibilities(clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_78117_n = false;
        modelplayer.field_78095_p = 0.0f;
        modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        modelplayer.field_178724_i.field_78795_f = 0.0f;
        modelplayer.field_178724_i.func_78785_a(0.0625f);
        modelplayer.field_178734_a.field_78795_f = 0.0f;
        modelplayer.field_178734_a.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
    }

    protected void func_77043_a(AbstractClientPlayer entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        if (this.applyRotationLockIfNeeded((EntityPlayer)entityLiving)) {
            return;
        }
        if (entityLiving.func_70089_S() && entityLiving.func_70608_bn()) {
            GlStateManager.func_179114_b((float)entityLiving.func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)entityLiving), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (entityLiving.func_184613_cA()) {
            super.func_77043_a(entityLiving, p_77043_2_, rotationYaw, partialTicks);
            float f = (float)entityLiving.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            super.func_77043_a(entityLiving, p_77043_2_, rotationYaw, partialTicks);
        }
    }

    private boolean applyRotationLockIfNeeded(EntityPlayer player) {
        IMixinEntityPlayerLaidDown newplayer = (IMixinEntityPlayerLaidDown)player;
        if (newplayer.minePieceMod$isLaidDown()) {
            float yaw;
            EnumFacing facing = newplayer.minePieceMod$getLaidDownFacing();
            double yOffset = newplayer.minePieceMod$getYOffset();
            double xOffset = newplayer.minePieceMod$getXOffset();
            switch (facing) {
                case EAST: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 90.0f;
                    break;
                }
                case WEST: {
                    yaw = 0.0f;
                    break;
                }
                default: {
                    yaw = 270.0f;
                }
            }
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)((AbstractClientPlayer)player)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-yOffset));
            GlStateManager.func_179137_b((double)0.0, (double)(-xOffset), (double)0.0);
            return true;
        }
        return false;
    }

    private float[] intToRgb(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }
}

