/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render;

import fr.minepiece.client.model.CustomPlayerModel;
import fr.minepiece.client.model.modifications.AbstractPlayerModification;
import fr.minepiece.client.model.registry.ModelRegistry;
import fr.minepiece.client.model.visibility.ModelVisibilityManager;
import fr.minepiece.client.render.layers.OptimizedLayerCustomBipedArmor;
import fr.minepiece.client.render.layers.OptimizedLayerCustomSkinRender;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class OptimizedRenderCustomPlayer
extends RenderPlayer {
    private final CustomPlayerModel customModel;

    public OptimizedRenderCustomPlayer(RenderManager renderManager) {
        this(renderManager, false);
    }

    public OptimizedRenderCustomPlayer(RenderManager renderManager, boolean useSmallArms) {
        super(renderManager, useSmallArms);
        this.customModel = new CustomPlayerModel(0.0f, useSmallArms);
        this.field_77045_g = this.customModel;
        this.removeArmorLayer();
        this.func_177094_a((LayerRenderer)new OptimizedLayerCustomBipedArmor((RenderLivingBase<?>)this));
        this.func_177094_a(new OptimizedLayerCustomSkinRender(this));
    }

    private void removeArmorLayer() {
        Iterator iterator = this.field_177097_h.iterator();
        while (iterator.hasNext()) {
            LayerRenderer layerRenderer = (LayerRenderer)iterator.next();
            if (!(layerRenderer instanceof LayerArmorBase)) continue;
            iterator.remove();
            break;
        }
    }

    public ModelPlayer func_177087_b() {
        return this.customModel;
    }

    public void func_76986_a(AbstractClientPlayer entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entity.func_175144_cb() || this.field_76990_c.field_78734_h == entity) {
            this.setModelVisibilities(entity);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    protected void renderModel(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        IPlayerModifications modifications = (IPlayerModifications)entitylivingbaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (modifications == null) {
            super.func_77036_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            return;
        }
        ModelPlayer model = this.func_177087_b();
        ModelVisibilityManager.resetVisibility((ModelBiped)model);
        if (!modifications.getModifications().isEmpty()) {
            ArrayList<AbstractPlayerModification> playerModifications = new ArrayList<AbstractPlayerModification>();
            for (String modificationName : modifications.getModifications()) {
                AbstractPlayerModification modification = ModelRegistry.getModification(modificationName);
                if (modification == null) continue;
                playerModifications.add(modification);
            }
            ModelVisibilityManager.applyVisibility(model, playerModifications);
            for (AbstractPlayerModification modification : playerModifications) {
                modification.setModelOffset(entitylivingbaseIn, model);
            }
        }
        this.renderEntityModel(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, true);
    }

    private void renderEntityModel(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, boolean bindSkin) {
        boolean isInvisibleToPlayer;
        boolean isEntityVisible = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = isInvisibleToPlayer = !isEntityVisible && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isEntityVisible || isInvisibleToPlayer) {
            if (bindSkin && !this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (isInvisibleToPlayer) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (isInvisibleToPlayer) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    public void renderEntityModelHeadOnly(AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, boolean bindSkin) {
        boolean isInvisibleToPlayer;
        boolean isEntityVisible = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = isInvisibleToPlayer = !isEntityVisible && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isEntityVisible || isInvisibleToPlayer) {
            if (bindSkin && !this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (isInvisibleToPlayer) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            ((CustomPlayerModel)this.field_77045_g).renderHeadOnly((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (isInvisibleToPlayer) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    public ResourceLocation func_110775_a(AbstractClientPlayer entity) {
        return entity.func_110306_p();
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected void func_77041_b(AbstractClientPlayer entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    private void setModelVisibilities(AbstractClientPlayer clientPlayer) {
        ModelPlayer modelplayer = this.func_177087_b();
        if (clientPlayer.func_175149_v()) {
            modelplayer.func_178719_a(false);
            modelplayer.field_78116_c.field_78806_j = true;
            modelplayer.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            modelplayer.func_178719_a(true);
            modelplayer.field_178720_f.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.HAT);
            modelplayer.field_178730_v.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.JACKET);
            modelplayer.field_178733_c.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
            modelplayer.field_178731_d.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
            modelplayer.field_178734_a.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
            modelplayer.field_178732_b.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
            modelplayer.field_78117_n = clientPlayer.func_70093_af();
            ModelBiped.ArmPose modelbiped$armpose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose modelbiped$armpose1 = ModelBiped.ArmPose.EMPTY;
            if (!itemstack.func_190926_b()) {
                modelbiped$armpose = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstack.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        modelbiped$armpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        modelbiped$armpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstack1.func_190926_b()) {
                modelbiped$armpose1 = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction1 = itemstack1.func_77975_n();
                    if (enumaction1 == EnumAction.BLOCK) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (clientPlayer.func_184591_cq() == EnumHandSide.RIGHT) {
                modelplayer.field_187076_m = modelbiped$armpose;
                modelplayer.field_187075_l = modelbiped$armpose1;
            } else {
                modelplayer.field_187076_m = modelbiped$armpose1;
                modelplayer.field_187075_l = modelbiped$armpose;
            }
        }
    }
}

