/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render;

import fr.minepiece.client.model.registry.ModelRegistry;
import fr.minepiece.client.render.OptimizedRenderCustomPlayer;
import fr.minepiece.client.render.texture.AsyncTextureGenerator;
import fr.minepiece.client.render.texture.TextureCache;
import fr.minepiece.client.render.texture.TextureManager;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModRegistry {
    private static boolean initialized = false;

    @SideOnly(value=Side.CLIENT)
    public static void initialize() {
        if (initialized) {
            return;
        }
        ModelRegistry.initialize();
        ModRegistry.replacePlayerRenderers();
        initialized = true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void replacePlayerRenderers() {
        try {
            RenderPlayer slimRenderer;
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Field skinMapField = RenderManager.class.getDeclaredField("skinMap");
            skinMapField.setAccessible(true);
            Map skinMap = (Map)skinMapField.get(renderManager);
            RenderPlayer defaultRenderer = (RenderPlayer)skinMap.get("default");
            if (defaultRenderer != null) {
                skinMap.put("default", new OptimizedRenderCustomPlayer(renderManager, false));
            }
            if ((slimRenderer = (RenderPlayer)skinMap.get("slim")) != null) {
                skinMap.put("slim", new OptimizedRenderCustomPlayer(renderManager, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModRegistry.initialize();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void shutdown() {
        if (!initialized) {
            return;
        }
        AsyncTextureGenerator.getInstance().shutdown();
        TextureCache.getInstance().clearCache();
        TextureManager.getInstance().clearCache();
        initialized = false;
    }
}

