/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.render;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="minepiece", value={Side.CLIENT})
public class LeashRenderer {
    private static final Map<UUID, UUID> clientLeashedPlayers = new ConcurrentHashMap<UUID, UUID>();

    public static void updateLeash(UUID leashedUUID, UUID holderUUID) {
        if (leashedUUID != null && holderUUID != null) {
            clientLeashedPlayers.put(leashedUUID, holderUUID);
            System.out.println("Client: Added/Updated leash for " + leashedUUID);
        }
    }

    public static void removeLeash(UUID leashedUUID) {
        if (clientLeashedPlayers.remove(leashedUUID) != null) {
            System.out.println("Client: Removed leash for " + leashedUUID);
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        RenderManager renderManager = mc.func_175598_ae();
        float partialTicks = event.getPartialTicks();
        double viewerX = renderManager.field_78730_l;
        double viewerY = renderManager.field_78731_m;
        double viewerZ = renderManager.field_78728_n;
        for (Map.Entry<UUID, UUID> entry : clientLeashedPlayers.entrySet()) {
            UUID leashedUUID = entry.getKey();
            UUID holderUUID = entry.getValue();
            EntityPlayer leashedPlayer = mc.field_71441_e.func_152378_a(leashedUUID);
            EntityPlayer holderPlayer = mc.field_71441_e.func_152378_a(holderUUID);
            if (leashedPlayer == null || holderPlayer == null) continue;
            double leashX = leashedPlayer.field_70142_S + (leashedPlayer.field_70165_t - leashedPlayer.field_70142_S) * (double)partialTicks;
            double leashY = leashedPlayer.field_70137_T + (leashedPlayer.field_70163_u - leashedPlayer.field_70137_T) * (double)partialTicks;
            double leashZ = leashedPlayer.field_70136_U + (leashedPlayer.field_70161_v - leashedPlayer.field_70136_U) * (double)partialTicks;
            double holderX = holderPlayer.field_70142_S + (holderPlayer.field_70165_t - holderPlayer.field_70142_S) * (double)partialTicks;
            double holderY = holderPlayer.field_70137_T + (holderPlayer.field_70163_u - holderPlayer.field_70137_T) * (double)partialTicks;
            double holderZ = holderPlayer.field_70136_U + (holderPlayer.field_70161_v - holderPlayer.field_70136_U) * (double)partialTicks;
            LeashRenderer.drawLeash(leashX - viewerX, (leashY += (double)leashedPlayer.field_70131_O * 0.5) - viewerY, leashZ - viewerZ, holderX - viewerX, (holderY += (double)holderPlayer.field_70131_O * 0.5) - viewerY, holderZ - viewerZ);
        }
    }

    private static void drawLeash(double x1, double y1, double z1, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double distSq = dx * dx + dz * dz;
        double dist = Math.sqrt(distSq);
        double sag = Math.max(0.0, dist * 0.1 - 0.2);
        float r1 = 0.627451f;
        float g1 = 0.32156864f;
        float b1 = 0.1764706f;
        float r2 = 0.8235294f;
        float g2 = 0.4117647f;
        float b2 = 0.11764706f;
        int segments = 8;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= segments; ++i) {
            boolean useColor1;
            float t = (float)i / (float)segments;
            double currentX = x1 + dx * (double)t;
            double currentY = y1 + dy * (double)t;
            double currentZ = z1 + dz * (double)t;
            currentY -= sag * Math.sin((double)t * Math.PI);
            boolean bl = useColor1 = i / 2 % 2 == 0;
            if (i % 2 == 0) {
                bufferbuilder.func_181662_b(currentX, currentY, currentZ).func_181666_a(r1, g1, b1, 1.0f).func_181675_d();
                continue;
            }
            bufferbuilder.func_181662_b(currentX, currentY, currentZ).func_181666_a(r2, g2, b2, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }
}

