/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.vfx.implementations;

import fr.minepiece.client.particles.vfx.helpers.ColorHelper;
import fr.minepiece.client.particles.vfx.helpers.MathHelper;
import fr.minepiece.client.particles.vfx.implementations.ParticleBlur;
import fr.minepiece.client.particles.vfx.implementations.ParticleCCBlur;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleFire
extends ParticleCCBlur {
    private int color1;
    private int color2;
    private float particleStretch = (float)MathHelper.getRandomBetween(0.03125, 0.0625);
    private float tailOff = (float)MathHelper.getRandomPlusMinus(5.0, 2.5);
    private boolean exploding = false;
    private boolean hasImpacted;

    public ParticleFire(World world, double x, double y, double z, float scale) {
        this(world, x, y, z);
        this.setScale(scale);
    }

    public ParticleFire(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setColliding();
        this.color1 = 0xFF0000 | this.field_187136_p.nextInt(127) << 8;
        this.color2 = ColorHelper.mixColors(0xFFFFFF, 0xFFFF00, this.field_187136_p.nextFloat());
        this.particleStretch = 0.0f;
    }

    public ParticleFire setMainColor(int startColor, int lastColor, float ratio) {
        this.color1 = startColor;
        this.color2 = ColorHelper.mixColors(startColor, lastColor, ratio);
        return this;
    }

    public ParticleFire setStretch(float s) {
        this.particleStretch = s;
        return this;
    }

    public ParticleFire setTailoff(float t) {
        this.tailOff = t;
        return this;
    }

    public ParticleFire setExploding() {
        this.exploding = true;
        return this;
    }

    @Override
    protected void onCollision() {
    }

    private void explode() {
        this.func_187112_i();
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float scale = this.field_70544_f;
        double y = this.field_187127_g;
        int n = this.hasImpacted ? 1 + (this.field_187136_p.nextInt(2) == 0 ? 1 : 2) : 2;
        ParticleBlur.BlendMode.ADDITIVEDARK.apply();
        for (int i = 0; i < n; ++i) {
            float ds = 1.0f - (float)i / this.tailOff;
            this.field_187127_g = y + (double)((float)i * scale * this.particleStretch);
            this.field_70544_f = scale * ds;
            this.setColor(this.color1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            this.setColor(this.color2);
            this.field_70544_f = scale * ds * 0.6f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
        this.field_70544_f = scale;
        this.field_187127_g = y;
    }

    @Override
    public boolean func_187111_c() {
        return true;
    }
}

