/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.vfx.implementations;

import fr.minepiece.client.particles.ModParticles;
import fr.minepiece.client.particles.vfx.helpers.ColorHelper;
import fr.minepiece.client.particles.vfx.implementations.ParticleBlur;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class ParticleCCBlur
extends ParticleBlur {
    private float cyclescale;
    private boolean mipmapsGenerated = false;

    public ParticleCCBlur(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    public ParticleCCBlur(World world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.field_187119_C = ModParticles.getTextureAtlasSpriteMap().get(ModParticles.CC_BLUR);
        this.setBasicBlend();
        this.setColor(-7601942);
        this.setAlphaFading(1.0f);
    }

    public final ParticleCCBlur setCyclingColor(float scale) {
        this.cyclescale = scale;
        return this;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        if (this.cyclescale > 0.0f) {
            int age = Math.max(this.field_70546_d, 1);
            int c = ParticleCCBlur.getBlendedColor((int)((float)age * this.cyclescale), 5);
            this.field_70552_h = (float)ColorHelper.getRed(c) / 255.0f;
            this.field_70553_i = (float)ColorHelper.getGreen(c) / 255.0f;
            this.field_70551_j = (float)ColorHelper.getBlue(c) / 255.0f;
        }
    }

    protected static int getBlendedColor(int tick, int mod) {
        if (tick < 0) {
            tick = -tick;
        }
        float mix = (float)(tick % mod) / (float)mod;
        return ColorHelper.mixColors(-16767233, -7601942, mix);
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.mipmapsGenerated) {
            this.generateMipmaps();
            this.mipmapsGenerated = true;
        }
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    protected void generateMipmaps() {
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL30.glGenerateMipmap((int)3553);
        GL11.glBindTexture((int)3553, (int)0);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public boolean func_187111_c() {
        return true;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Nullable
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleCCBlur(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        }
    }
}

