/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.vfx.implementations;

import fr.minepiece.client.particles.vfx.ParticleEngine;
import fr.minepiece.client.particles.vfx.controllers.ColorController;
import fr.minepiece.client.particles.vfx.controllers.MotionController;
import fr.minepiece.client.particles.vfx.controllers.PositionController;
import fr.minepiece.client.particles.vfx.helpers.ColorHelper;
import fr.minepiece.common.mixin.ParticleAccessor;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleBlur
extends Particle {
    private float scale;
    private boolean noSlow = false;
    private boolean rapidExpand = false;
    private float alphaFade = 0.0f;
    private AxisAlignedBB bounds = null;
    private int bounceAction = 0;
    private double collideAngle;
    private boolean colliding = false;
    private int clearOnCollide = -1;
    private int lifeFreeze;
    private int preColor = -1;
    private int fadeColor = -1;
    private float defaultRed;
    private float defaultGreen;
    private float defaultBlue;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;
    private double drag;
    private BlockPos destination;
    private Particle lock;
    private Collection<Particle> locks = new HashSet<Particle>();
    private boolean additiveBlend = true;
    private boolean depthTest = true;
    private boolean alphaTest = false;
    private boolean renderOverLimit = false;
    private ParticleEngine.RenderMode renderMode;
    private MotionController motionController;
    private PositionController positionController;
    private ColorController colorController;

    public ParticleBlur(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_70545_g = 0.0f;
        this.field_190017_n = false;
        this.field_70547_e = 60;
        this.field_187129_i = xSpeedIn;
        this.field_187130_j = ySpeedIn;
        this.field_187131_k = zSpeedIn;
        this.alphaTest = false;
        this.additiveBlend = true;
    }

    public final ParticleBlur setScale(float f) {
        this.scale = f;
        this.setScaleFromAge(Math.max(this.field_70546_d, 1));
        return this;
    }

    public final ParticleBlur setLife(int time) {
        this.field_70547_e = time;
        return this;
    }

    public final ParticleBlur setNoSlowdown() {
        this.noSlow = true;
        return this;
    }

    public final ParticleBlur setRapidExpand() {
        this.rapidExpand = true;
        return this;
    }

    public final ParticleBlur setAlphaFading() {
        return this.setAlphaFading(1.0f);
    }

    public final ParticleBlur setAlphaFading(float f) {
        this.alphaFade = f;
        return this;
    }

    public final ParticleBlur setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public final ParticleBlur setDrag(double d) {
        this.drag = d;
        return this;
    }

    public final ParticleBlur setColor(int r, int g, int b) {
        this.defaultRed = this.field_70552_h = (float)r / 255.0f;
        this.defaultGreen = this.field_70553_i = (float)g / 255.0f;
        this.defaultBlue = this.field_70551_j = (float)b / 255.0f;
        return this;
    }

    public final ParticleBlur setColor(int rgb) {
        return this.setColor(ColorHelper.getRed(rgb), ColorHelper.getGreen(rgb), ColorHelper.getBlue(rgb));
    }

    public int getColor() {
        return ColorHelper.RGBtoHex((int)this.field_70552_h, (int)this.field_70553_i, (int)this.field_70551_j);
    }

    public boolean isAlphaFading() {
        return this.alphaFade > 0.0f;
    }

    public final ParticleBlur fadeColors(int c1, int c2) {
        this.preColor = c1;
        this.fadeColor = c2;
        return this.setColor(c1);
    }

    public final ParticleBlur bound(AxisAlignedBB box, boolean bounce, boolean cull) {
        this.bounds = box;
        this.bounceAction = (bounce ? 1 : 0) | (cull ? 2 : 0);
        return this;
    }

    public final ParticleBlur setColliding() {
        return this.setColliding(-1);
    }

    public final ParticleBlur setColliding(int clear) {
        return this.setColliding(this.field_187136_p.nextDouble() * 360.0, clear);
    }

    public final ParticleBlur setColliding(double ang) {
        return this.setColliding(ang, -1);
    }

    public final ParticleBlur setColliding(double ang, int clear) {
        this.field_190017_n = true;
        this.colliding = true;
        this.collideAngle = ang;
        this.clearOnCollide = clear;
        this.onSetColliding();
        return this;
    }

    protected void onSetColliding() {
    }

    public final ParticleBlur markDestination(int x, int y, int z) {
        this.destination = new BlockPos(x, y, z);
        return this;
    }

    public final ParticleBlur lockTo(ParticleBlur fx) {
        this.lock = fx;
        if (this == fx) {
            System.out.println("Cannot lock a particle to itself!");
            return this;
        }
        if (fx instanceof ParticleBlur) {
            ParticleBlur bfx = fx;
            if (!bfx.getRenderMode().equals(this.getRenderMode())) {
                System.out.println("Cannot accurately lock two different particle render types: " + (Object)((Object)fx) + " & " + (Object)((Object)this));
            }
            bfx.locks.add(this);
        }
        return this;
    }

    public final ParticleBlur setAcceleration(double x, double y, double z) {
        this.accelerationX = x;
        this.accelerationY = y;
        this.accelerationZ = z;
        return this;
    }

    public final ParticleBlur setAdditiveBlend() {
        this.additiveBlend = true;
        this.renderMode = null;
        return this;
    }

    public final ParticleBlur setBasicBlend() {
        this.additiveBlend = false;
        this.renderMode = null;
        return this;
    }

    public final ParticleBlur setNoDepthTest() {
        this.depthTest = false;
        this.renderMode = null;
        return this;
    }

    public final ParticleBlur enableAlphaTest() {
        this.alphaTest = true;
        this.renderMode = null;
        return this;
    }

    public final ParticleBlur forceIgnoreLimits() {
        this.renderOverLimit = true;
        return this;
    }

    public final ParticleBlur setAge(int age) {
        this.field_70546_d = age;
        return this;
    }

    public final ParticleBlur freezeLife(int ticks) {
        this.lifeFreeze = ticks;
        return this;
    }

    public final ParticleBlur setMotionController(MotionController m) {
        this.motionController = m;
        return this;
    }

    public final ParticleBlur setPositionController(PositionController m) {
        this.positionController = m;
        return this;
    }

    public final ParticleBlur setColorController(ColorController m) {
        this.colorController = m;
        return this;
    }

    protected final boolean isAlphaFade() {
        return this.alphaFade > 0.0f;
    }

    public final int getMaxAge() {
        return this.field_70547_e;
    }

    public final float getGravity() {
        return this.field_70545_g;
    }

    public final int getMaximumSizeAge() {
        return this.rapidExpand ? this.field_70547_e / 12 : this.field_70547_e / 2;
    }

    public void func_189213_a() {
        BlockPos c;
        if (this.field_70546_d < 0) {
            return;
        }
        if (this.colliding && this.field_187132_l) {
            double v = this.field_187136_p.nextDouble() * 0.0625;
            if (Double.isFinite(this.collideAngle)) {
                this.field_187129_i = v * Math.sin(Math.toRadians(this.collideAngle));
                this.field_187131_k = v * Math.cos(Math.toRadians(this.collideAngle));
            } else {
                double vel = fr.minepiece.client.particles.vfx.helpers.MathHelper.py3d(this.field_187129_i, 0.0, this.field_187131_k);
                this.field_187129_i = this.field_187129_i * v / vel;
                this.field_187131_k = this.field_187131_k * v / vel;
            }
            this.colliding = false;
            this.setNoSlowdown();
            if (this.clearOnCollide != Integer.MIN_VALUE) {
                this.lifeFreeze = this.clearOnCollide >= 0 ? Math.min(this.clearOnCollide, 20) : 20;
            }
            this.field_70545_g *= 4.0f;
            if (this.clearOnCollide >= 0) {
                this.setLife(Math.max(1, this.clearOnCollide - this.lifeFreeze));
            }
            this.onCollision();
        }
        if (this.destination != null && (c = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).equals((Object)this.destination)) {
            this.func_187112_i();
        }
        this.field_187129_i += this.accelerationX;
        this.field_187130_j += this.accelerationY;
        this.field_187131_k += this.accelerationZ;
        if (this.noSlow) {
            double mx = this.field_187129_i;
            double my = this.field_187130_j;
            double mz = this.field_187131_k;
            super.func_189213_a();
            this.field_187129_i = mx;
            this.field_187130_j = my;
            this.field_187131_k = mz;
        } else {
            if (this.drag != 0.0) {
                this.field_187129_i *= this.drag;
                this.field_187130_j *= this.drag;
                this.field_187131_k *= this.drag;
            }
            super.func_189213_a();
        }
        if (this.lifeFreeze > 0) {
            --this.lifeFreeze;
            --this.field_70546_d;
        }
        int age = Math.max(this.field_70546_d, 1);
        if (this.fadeColor != -1) {
            int c2 = ColorHelper.mixColors(this.fadeColor, this.preColor, (float)age / (float)this.field_70547_e);
            this.setColor(c2);
        }
        this.setScaleFromAge(age);
        if (this.bounds != null) {
            boolean cull;
            boolean bounce = (this.bounceAction & 1) != 0;
            boolean bl = cull = (this.bounceAction & 2) != 0;
            if (this.field_187126_f <= this.bounds.field_72340_a && this.field_187129_i < 0.0 || this.field_187126_f >= this.bounds.field_72336_d && this.field_187129_i > 0.0) {
                double d = this.field_187129_i = bounce ? -this.field_187129_i : 0.0;
                if (cull) {
                    this.func_187112_i();
                }
            }
            if (this.field_187127_g <= this.bounds.field_72338_b && this.field_187130_j < 0.0 || this.field_187127_g >= this.bounds.field_72337_e && this.field_187130_j > 0.0) {
                double d = this.field_187130_j = bounce ? -this.field_187130_j : 0.0;
                if (cull) {
                    this.func_187112_i();
                }
            }
            if (this.field_187128_h <= this.bounds.field_72339_c && this.field_187131_k < 0.0 || this.field_187128_h >= this.bounds.field_72334_f && this.field_187131_k > 0.0) {
                double d = this.field_187131_k = bounce ? -this.field_187131_k : 0.0;
                if (cull) {
                    this.func_187112_i();
                }
            }
        }
        if (this.lock != null) {
            this.field_187126_f = ((ParticleAccessor)this.lock).getPosX();
            this.field_187127_g = ((ParticleAccessor)this.lock).getPosY();
            this.field_187128_h = ((ParticleAccessor)this.lock).getPosZ();
            this.field_187129_i = ((ParticleAccessor)this.lock).getMotionX();
            this.field_187130_j = ((ParticleAccessor)this.lock).getMotionY();
            this.field_187131_k = ((ParticleAccessor)this.lock).getMotionZ();
        }
        if (!this.locks.isEmpty()) {
            for (Particle particle : this.locks) {
                ((ParticleAccessor)particle).setMotionX(this.field_187129_i);
                ((ParticleAccessor)particle).setMotionY(this.field_187130_j);
                ((ParticleAccessor)particle).setMotionZ(this.field_187131_k);
            }
        }
        if (this.motionController != null) {
            this.field_187129_i = this.motionController.getMotionX(this);
            this.field_187130_j = this.motionController.getMotionY(this);
            this.field_187131_k = this.motionController.getMotionZ(this);
            this.motionController.update(this);
        }
        if (this.positionController != null) {
            this.field_187126_f = this.positionController.getPositionX(this);
            this.field_187127_g = this.positionController.getPositionY(this);
            this.field_187128_h = this.positionController.getPositionZ(this);
            if (this.positionController != this.motionController) {
                this.positionController.update(this);
            }
        }
        if (this.colorController != null) {
            int rgb = this.colorController.getColor(this);
            float f = 1.0f;
            if (this.alphaFade > 0.0f) {
                f = this.rapidExpand ? (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
            }
            this.field_70552_h = (float)ColorHelper.getRed(rgb) * f / 255.0f;
            this.field_70553_i = (float)ColorHelper.getGreen(rgb) * f / 255.0f;
            this.field_70551_j = (float)ColorHelper.getBlue(rgb) * f / 255.0f;
            this.colorController.update(this);
        }
    }

    private void setScaleFromAge(int age) {
        if (this.alphaFade > 0.0f) {
            this.field_70544_f = this.scale;
            float f = 1.0f;
            f = this.rapidExpand ? (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
            if (this.additiveBlend) {
                this.field_70552_h = this.defaultRed * f;
                this.field_70553_i = this.defaultGreen * f;
                this.field_70551_j = this.defaultBlue * f;
            } else {
                this.field_82339_as = f * this.alphaFade;
            }
        } else {
            this.field_70544_f = this.rapidExpand ? this.scale * (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : this.scale * MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
        }
    }

    protected void onCollision() {
    }

    public final int func_70537_b() {
        return 1;
    }

    public final ParticleEngine.RenderMode getRenderMode() {
        if (this.renderMode == null) {
            this.renderMode = new ParticleEngine.RenderMode().setFlag(ParticleEngine.RenderModeFlags.FOG, false).setFlag(ParticleEngine.RenderModeFlags.ADDITIVE, this.additiveBlend).setFlag(ParticleEngine.RenderModeFlags.DEPTH, this.depthTest).setFlag(ParticleEngine.RenderModeFlags.LIGHT, false).setFlag(ParticleEngine.RenderModeFlags.ALPHACLIP, this.alphaTest && this.additiveBlend);
        }
        return this.renderMode;
    }

    public boolean rendersOverLimit() {
        return this.renderOverLimit;
    }

    public static void disableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void enableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static int booleanToBitflags(boolean[] flags) {
        if (flags.length > 31) {
            throw new IllegalArgumentException("You cannot store more than 31 bits on an int!");
        }
        int n = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (!flags[i]) continue;
            n += 1 << i;
        }
        return n;
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public void setMotionX(double motionX) {
        this.field_187129_i = motionX;
    }

    public void setMotionY(double motionY) {
        this.field_187130_j = motionY;
    }

    public void setMotionZ(double motionZ) {
        this.field_187131_k = motionZ;
    }

    public void setMotion(double motionX, double motionY, double motionZ) {
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
    }

    public float getScale() {
        return this.scale;
    }

    public static enum BlendMode {
        DEFAULT(770, 771),
        ALPHA(1, 770),
        PREALPHA(1, 771),
        MULTIPLY(774, 771),
        ADDITIVE(1, 1),
        ADDITIVEDARK(1, 769),
        OVERLAYDARK(768, 1),
        ADDITIVE2(770, 1),
        INVERTEDADD(775, 769);

        public final int sfactor;
        public final int dfactor;

        private BlendMode(int s, int d) {
            this.sfactor = s;
            this.dfactor = d;
        }

        public void apply() {
            GL11.glBlendFunc((int)this.sfactor, (int)this.dfactor);
            if (this.isColorBlending()) {
                GL11.glDisable((int)2912);
            }
        }

        public boolean isColorBlending() {
            return this == ADDITIVE || this == ADDITIVE2 || this == ADDITIVEDARK;
        }
    }
}

