/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.vfx.helpers;

import java.util.Random;

public class MathHelper {
    public static final Random rand = new Random();

    public static double py3d(double dx, double dy, double dz) {
        double val = dx * dx + dy * dy + dz * dz;
        return Math.sqrt(val);
    }

    public static int getRandomBetween(int min, int max) {
        return MathHelper.getRandomBetween(min, max, rand);
    }

    public static double getRandomBetween(double min, double max) {
        return MathHelper.getRandomBetween(min, max, rand);
    }

    public static int getRandomBetween(int min, int max, Random r) {
        return min == max ? min : min + r.nextInt(1 + max - min);
    }

    public static double getRandomBetween(double min, double max, Random r) {
        return min == max ? min : min + r.nextDouble() * (max - min);
    }

    public static double getRandomPlusMinus(double base, double range) {
        return MathHelper.getRandomPlusMinus(base, range, rand);
    }

    public static int getRandomPlusMinus(int base, int range) {
        return MathHelper.getRandomPlusMinus(base, range, rand);
    }

    public static double getRandomPlusMinus(double base, double range, Random r) {
        double add = -range + r.nextDouble() * range * 2.0;
        return base + add;
    }

    public static int getRandomPlusMinus(int base, int range, Random r) {
        int add = -range + r.nextInt(range * 2 + 1);
        return base + add;
    }

    public static int booleanToBitflags(boolean[] flags) {
        if (flags.length > 31) {
            throw new IllegalArgumentException("You cannot store more than 31 bits on an int!");
        }
        int n = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (!flags[i]) continue;
            n += 1 << i;
        }
        return n;
    }
}

