/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.vfx;

import fr.minepiece.client.particles.vfx.helpers.MathHelper;
import fr.minepiece.client.particles.vfx.implementations.ParticleBlur;
import java.util.Arrays;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class ParticleEngine
extends ParticleManager {
    protected ParticleEngine() {
        super(null, null);
    }

    public static void disableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void enableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static boolean renderThroughWalls() {
        return Keyboard.isKeyDown((int)210);
    }

    public static enum RenderModeFlags {
        ALPHA(true),
        LIGHT(true),
        ADDITIVE(false),
        DEPTH(true),
        ALPHACLIP(true),
        FOG(true);

        private final boolean defaultValue;
        private static final RenderModeFlags[] list;

        private RenderModeFlags(boolean f) {
            this.defaultValue = f;
        }

        private int getFlag() {
            return 1 << this.ordinal();
        }

        private void apply(boolean set) {
            switch (this) {
                case LIGHT: {
                    if (set) {
                        GL11.glEnable((int)2896);
                        ParticleEngine.enableEntityLighting();
                        break;
                    }
                    GL11.glDisable((int)2896);
                    ParticleEngine.disableEntityLighting();
                    break;
                }
                case ALPHA: {
                    if (set) {
                        GL11.glEnable((int)3042);
                        break;
                    }
                    GL11.glDisable((int)3042);
                    break;
                }
                case ADDITIVE: {
                    if (set) {
                        ParticleBlur.BlendMode.ADDITIVEDARK.apply();
                        break;
                    }
                    ParticleBlur.BlendMode.DEFAULT.apply();
                    break;
                }
                case DEPTH: {
                    if (set && !ParticleEngine.renderThroughWalls()) {
                        GL11.glEnable((int)2929);
                        break;
                    }
                    GL11.glDisable((int)2929);
                    break;
                }
                case ALPHACLIP: {
                    if (set) {
                        GL11.glEnable((int)3008);
                        break;
                    }
                    GL11.glDisable((int)3008);
                    break;
                }
                case FOG: {
                    if (set) {
                        GL11.glEnable((int)2912);
                        break;
                    }
                    GL11.glDisable((int)2912);
                }
            }
        }

        static {
            list = RenderModeFlags.values();
        }
    }

    public static final class RenderMode {
        private final boolean[] flags = new boolean[RenderModeFlags.access$000().length];

        public RenderMode() {
            for (int i = 0; i < this.flags.length; ++i) {
                this.flags[i] = RenderModeFlags.list[i].defaultValue;
            }
        }

        public RenderMode setFlag(RenderModeFlags f, boolean flag) {
            this.flags[f.ordinal()] = flag;
            return this;
        }

        public int hashCode() {
            return MathHelper.booleanToBitflags(this.flags);
        }

        public boolean equals(Object o) {
            if (o instanceof RenderMode) {
                RenderMode r = (RenderMode)o;
                return Arrays.equals(this.flags, r.flags);
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.flags);
        }

        private void apply() {
            for (int i = 0; i < this.flags.length; ++i) {
                RenderModeFlags.list[i].apply(this.flags[i]);
            }
        }
    }
}

