/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles.lightning;

import fr.minepiece.client.particles.lightning.LightningFX;
import java.util.Random;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LightningArcFX
extends LightningFX {
    private static final Random RANDOM_GENERATOR = new Random();
    private final double relativeX;
    private final double relativeY;
    private final double relativeZ;

    public LightningArcFX(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(world, startX, startY, startZ, xSpeedIn, ySpeedIn, zSpeedIn, 6);
        this.relativeX = endX - startX;
        this.relativeY = endY - startY;
        this.relativeZ = endZ - startZ;
        this.regen();
    }

    @Override
    protected void regen() {
        double i = 1.0 / (double)(this.getSteps() - 1);
        double lastDirectionX = this.relativeX * i;
        double lastDirectionY = this.relativeY * i;
        double lastDirectionZ = this.relativeZ * i;
        double len = Math.sqrt(lastDirectionX * lastDirectionX + lastDirectionY * lastDirectionY + lastDirectionZ * lastDirectionZ);
        for (int s = 0; s < this.getSteps(); ++s) {
            double[][] localSteps = this.getPrecomputedSteps();
            localSteps[s][0] = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][1] = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][2] = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new LightningArcFX(worldIn, xCoordIn, yCoordIn, zCoordIn, xCoordIn - 1.0, yCoordIn - 1.0, zCoordIn - 1.0, xSpeedIn, ySpeedIn, zSpeedIn);
        }
    }
}

