/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.particles;

import fr.minepiece.client.particles.ModParticles;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleSmoke
extends Particle {
    private int textureindex = 0;
    private final List<Integer> textureDurations;
    private static final int LIFETIME_TICKS = 600;
    private boolean finalTextureReached = false;
    private int textureAgeCounter = 0;

    public ParticleSmoke(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_187129_i = xSpeedIn * 0.1;
        this.field_187130_j = ySpeedIn * 0.2;
        this.field_187131_k = zSpeedIn * 0.1;
        this.field_70544_f = 1.5f;
        this.field_82339_as = 1.0f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.textureDurations = Arrays.asList(4, 5, 6, 7, 7, 7, 8, 8, 400, 300, 10, 7);
        this.field_70547_e = 600;
        this.field_190017_n = false;
        this.resetTextureAgeCounter();
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if ((double)this.field_70546_d > (double)this.field_70547_e * 0.9) {
            float factor = (float)(this.field_70547_e - this.field_70546_d) / ((float)this.field_70547_e * 0.1f);
            this.field_82339_as = Math.max(0.1f, factor);
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        if (!this.finalTextureReached) {
            ++this.textureAgeCounter;
            if (this.textureindex < this.textureDurations.size()) {
                int currentTextureDuration = this.textureDurations.get(this.textureindex);
                if (this.textureAgeCounter >= currentTextureDuration) {
                    this.nextTexture();
                }
            } else {
                this.finalTextureReached = true;
            }
        }
        this.field_187130_j *= 0.96;
        this.field_187129_i *= 0.96;
        this.field_187131_k *= 0.96;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187136_p.nextInt(40) == 0) {
            this.field_187129_i += ((double)this.field_187136_p.nextFloat() - 0.5) * 0.002;
            this.field_187131_k += ((double)this.field_187136_p.nextFloat() - 0.5) * 0.002;
        }
    }

    private void resetTextureAgeCounter() {
        this.textureAgeCounter = 0;
    }

    private void nextTexture() {
        this.resetTextureAgeCounter();
        ++this.textureindex;
        if (this.textureindex >= ModParticles.smokebombTextures.size()) {
            this.finalTextureReached = true;
            this.textureindex = ModParticles.smokebombTextures.size() - 1;
        }
    }

    public void func_180434_a(BufferBuilder buffer_ignore, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        TextureAtlasSprite currentSprite = ModParticles.smokebombTextures.get(this.textureindex);
        float minU = currentSprite.func_94209_e();
        float maxU = currentSprite.func_94212_f();
        float minV = currentSprite.func_94206_g();
        float maxV = currentSprite.func_94210_h();
        float interpX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float interpY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float interpZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        float scale = this.field_70544_f * 1.5f;
        int combinedBrightness = this.func_189214_a(partialTicks);
        int skyLight = combinedBrightness >> 16 & 0xFFFF;
        int blockLight = combinedBrightness & 0xFFFF;
        Vec3d[] corners = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        buffer.func_181662_b((double)interpX + corners[0].field_72450_a, (double)interpY + corners[0].field_72448_b, (double)interpZ + corners[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b((double)interpX + corners[1].field_72450_a, (double)interpY + corners[1].field_72448_b, (double)interpZ + corners[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b((double)interpX + corners[2].field_72450_a, (double)interpY + corners[2].field_72448_b, (double)interpZ + corners[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b((double)interpX + corners[3].field_72450_a, (double)interpY + corners[3].field_72448_b, (double)interpZ + corners[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public int func_70537_b() {
        return 3;
    }

    public boolean func_187111_c() {
        return false;
    }

    public int func_189214_a(float partialTick) {
        return 0xF000F0;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            ParticleSmoke particle = new ParticleSmoke(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
            return particle;
        }
    }
}

